/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest.auth;

import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksFilterBinding;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;

@Provider
@Priority(value=1000)
@AdminApplicationLinksFilterBinding
public class AdminApplicationLinksFilter
implements ContainerRequestFilter {
    private final AdminUIAuthenticator authenticator;
    private final I18nResolver i18nResolver;

    @Inject
    public AdminApplicationLinksFilter(AdminUIAuthenticator authenticator, I18nResolver i18nResolver) {
        this.authenticator = authenticator;
        this.i18nResolver = i18nResolver;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MultivaluedMap params = requestContext.getUriInfo().getQueryParameters();
        if (!this.authenticator.checkAdminUIAccessByPasswordOrCurrentUser((String)params.getFirst((Object)"al_username"), (String)params.getFirst((Object)"al_password"))) {
            requestContext.abortWith(RestUtil.unauthorized(this.i18nResolver.getText("applinks.error.only.admin")));
        }
    }
}

