/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.upgrade;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.PropertySet;
import com.atlassian.applinks.core.property.ApplicationLinkProperties;
import com.atlassian.applinks.core.property.PropertyService;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoveTrustedAppsAppLinksUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(RemoveTrustedAppsAppLinksUpgradeTask.class);
    private static final String PROPERTY_TRUSTED_APPS_INCOMING_ID = "trustedapps.incoming.applicationId";
    private static final String TRUSTED_APPS_AUTH_PROVIDER = "com.atlassian.applinks.api.auth.types.TrustedAppsAuthenticationProvider";
    private final MutatingApplicationLinkService applicationLinkService;
    private final PropertyService propertyService;
    private final ApplicationProperties applicationProperties;
    private final ObjectMapper mapper;

    @Autowired
    public RemoveTrustedAppsAppLinksUpgradeTask(MutatingApplicationLinkService applicationLinkService, PropertyService propertyService, ApplicationProperties applicationProperties) {
        this.applicationLinkService = applicationLinkService;
        this.propertyService = propertyService;
        this.applicationProperties = applicationProperties;
        this.mapper = new ObjectMapper();
    }

    public int getBuildNumber() {
        return 11;
    }

    @Nonnull
    public String getShortDescription() {
        return "Removal of the Trusted Apps Application Links";
    }

    @Nullable
    public Collection<Message> doUpgrade() throws Exception {
        log.info("About to execute upgrade task for Trusted Apps removal.");
        Path destinationFile = this.createDestinationFile();
        Iterable applicationLinks = this.applicationLinkService.getApplicationLinks();
        if (Objects.nonNull(applicationLinks) && applicationLinks.iterator().hasNext()) {
            ArrayNode rootArrayNode = this.mapper.createArrayNode();
            applicationLinks.forEach(applicationLink -> {
                ApplicationLinkProperties appLinkProperties = this.propertyService.getApplicationLinkProperties(applicationLink.getId());
                List<String> providerKeys = appLinkProperties.getProviderKeys();
                if (providerKeys.contains(TRUSTED_APPS_AUTH_PROVIDER)) {
                    rootArrayNode.add((JsonNode)this.createObjectNode((ApplicationLink)applicationLink));
                    this.applicationLinkService.deleteApplicationLink(applicationLink);
                    log.info("Removed Trusted Apps application link with id: {}", (Object)applicationLink.getId());
                }
            });
            try (BufferedWriter writer = Files.newBufferedWriter(destinationFile, new OpenOption[0]);){
                this.mapper.writeValue((Writer)writer, (Object)rootArrayNode);
            }
            log.info("Deleted Trusted Apps application links has been saved to {}", (Object)destinationFile.toAbsolutePath());
        } else {
            log.info("No application links found, nothing to remove.");
        }
        return List.of();
    }

    private ObjectNode createObjectNode(ApplicationLink applicationLink) {
        ObjectNode objectNode = this.mapper.createObjectNode();
        PropertySet adminProperties = this.propertyService.getAdminProperties(applicationLink.getId());
        for (ApplicationLinkProperties.Property prop : ApplicationLinkProperties.Property.values()) {
            Object propVal = adminProperties.getProperty(prop.key());
            if (!Objects.nonNull(propVal)) continue;
            objectNode.putPOJO(prop.key(), propVal);
        }
        Object trustedAppsIncomingId = applicationLink.getProperty(PROPERTY_TRUSTED_APPS_INCOMING_ID);
        if (Objects.nonNull(trustedAppsIncomingId)) {
            objectNode.putPOJO(PROPERTY_TRUSTED_APPS_INCOMING_ID, trustedAppsIncomingId);
        }
        return objectNode;
    }

    private Path createDestinationFile() throws IOException {
        Path localDir = (Path)this.applicationProperties.getSharedHomeDirectory().or(() -> ((ApplicationProperties)this.applicationProperties).getLocalHomeDirectory()).orElseThrow(() -> new FileNotFoundException("Couldn't find shared or local home directory"));
        Path trustedAppsDir = localDir.resolve("config/trusted-apps");
        if (!Files.exists(trustedAppsDir, new LinkOption[0])) {
            Files.createDirectories(trustedAppsDir, new FileAttribute[0]);
        }
        return RemoveTrustedAppsAppLinksUpgradeTask.createDestinationPath(trustedAppsDir);
    }

    private static Path createDestinationPath(Path trustedAppsDir) throws IOException {
        for (int iteration = 0; iteration < 5; ++iteration) {
            try {
                String filename = "deleted_trusted_apps_applinks_" + String.valueOf(UUID.randomUUID()) + ".json";
                Path destinationFile = trustedAppsDir.resolve(filename);
                return Files.createFile(destinationFile, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                log.warn("File already exists, retrying to create a unique file: {}", (Object)e.getMessage());
                continue;
            }
        }
        throw new IOException("Failed to create a unique file for trusted apps upgrade task after 5 attempts.");
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.applinks.applinks-plugin";
    }
}

