/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.util;

import com.atlassian.applinks.api.auth.types.ThreeLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.core.rest.model.ApplicationLinkProviderInfoEntity;
import com.atlassian.applinks.core.rest.model.CloudTenantInfoEntity;
import com.atlassian.applinks.core.rest.model.ProviderInfoModel;
import com.atlassian.applinks.core.rest.model.RestOAuth2AuthorizationServerMetadata;
import com.atlassian.applinks.internal.common.exception.DefaultServiceExceptionFactory;
import com.atlassian.applinks.internal.common.exception.InvalidRequestException;
import com.atlassian.applinks.internal.common.exception.OAuth2NotSupportedException;
import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseStatusException;
import jakarta.ws.rs.core.UriBuilder;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationLinkOAuth2Support {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationLinkOAuth2Support.class);
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final String CLOUD_TENANT_INFO_ENDPOINT = "/_edge/tenant_info";
    private final ManifestRetriever manifestRetriever;
    private final RequestFactory<Request<?, ?>> requestFactory;
    private final DefaultServiceExceptionFactory serviceExceptionFactory;

    @Autowired
    public ApplicationLinkOAuth2Support(ManifestRetriever manifestRetriever, RequestFactory<Request<?, ?>> requestFactory, DefaultServiceExceptionFactory serviceExceptionFactory) {
        this.manifestRetriever = manifestRetriever;
        this.requestFactory = requestFactory;
        this.serviceExceptionFactory = serviceExceptionFactory;
    }

    private Manifest getManifestSilently(URI rpcUrl) {
        try {
            return this.getManifest(rpcUrl);
        }
        catch (ManifestNotFoundException e) {
            LOG.warn("Could not find manifest for rpcUrl {}", (Object)rpcUrl);
            return null;
        }
        catch (OAuth2NotSupportedException e) {
            LOG.warn("OAuth2 is not supported for the remote application at {}", (Object)rpcUrl);
            return null;
        }
    }

    public Manifest getManifest(URI rpcUrl) throws ManifestNotFoundException, OAuth2NotSupportedException {
        Manifest manifest = this.manifestRetriever.getManifest(rpcUrl);
        if (!ApplicationLinkOAuth2Support.isOAuth2Supported(manifest)) {
            throw new OAuth2NotSupportedException("OAuth2 is not supported for the remote application.");
        }
        return manifest;
    }

    public boolean isOAuth2Supported(ApplicationLinkDetails details) {
        return this.isOAuth2Supported(details.getRpcUrl());
    }

    public boolean isOAuth2Supported(URI rpcUrl) {
        Manifest manifest = this.getManifestSilently(rpcUrl);
        return ApplicationLinkOAuth2Support.isOAuth2Supported(manifest);
    }

    public static boolean isOAuth2Supported(Manifest manifest) {
        if (manifest == null || manifest.getInboundAuthenticationTypes() == null) {
            return false;
        }
        return manifest.getInboundAuthenticationTypes().stream().map(Class::getName).anyMatch(name -> name.contains(ThreeLeggedOAuth2AuthenticationProvider.class.getName()));
    }

    public boolean isOAuth2ClientCredentialsSupported(URI rpcUrl) {
        Manifest manifest = this.getManifestSilently(rpcUrl);
        if (manifest == null || manifest.getInboundAuthenticationTypes() == null) {
            return false;
        }
        return manifest.getInboundAuthenticationTypes().stream().map(Class::getName).anyMatch(name -> name.contains(TwoLeggedOAuth2AuthenticationProvider.class.getName()));
    }

    public boolean isDC(URI rpcUrl) {
        Manifest manifest = this.getManifestSilently(rpcUrl);
        return this.isDC(manifest);
    }

    private boolean isDC(Manifest manifest) {
        if (manifest == null) {
            return false;
        }
        return !manifest.isCloud();
    }

    public boolean isCloud(URI rpcUrl) {
        Manifest manifest = this.getManifestSilently(rpcUrl);
        return ApplicationLinkOAuth2Support.isCloud(manifest);
    }

    public static boolean isCloud(Manifest manifest) {
        if (manifest == null) {
            return false;
        }
        return manifest.isCloud();
    }

    public ProviderInfoModel getProviderInfo(URI rpcUrl) throws ServiceException {
        Manifest manifest = this.getManifestSilently(rpcUrl);
        if (this.isDC(manifest)) {
            URI oAuthProviderInfo = UriBuilder.fromUri((URI)rpcUrl).path("rest").path("oauth2").path("1.0").path(".well-known").path("oauth-authorization-server").queryParam("applinks", new Object[]{"true"}).build(new Object[0]);
            RestOAuth2AuthorizationServerMetadata response = this.getEntity(oAuthProviderInfo, RestOAuth2AuthorizationServerMetadata.class, "OAuth 2.0 Provider Info");
            return new ProviderInfoModel(response.getAuthorizationEndpoint(), response.getTokenEndpoint(), response.getScopesSupported(), rpcUrl, Collections.emptyMap());
        }
        if (ApplicationLinkOAuth2Support.isCloud(manifest)) {
            ApplicationLinkProviderInfoEntity providerInfo = this.getCloudProviderInfo(rpcUrl);
            CloudTenantInfoEntity tenantInfo = this.getCloudTenantInfo(manifest);
            URI cloudRpcUrl = UriBuilder.fromUri((URI)providerInfo.getRpcUrl()).path(tenantInfo.getCloudId()).build(new Object[0]);
            return new ProviderInfoModel(providerInfo.getAuthorizationUrl().toString(), providerInfo.getExchangeUrl().toString(), new HashSet<String>(providerInfo.getScopes()), cloudRpcUrl, Map.of("audience", List.of(providerInfo.getAudience())));
        }
        throw new InvalidRequestException("Unknown application host. Failed to fetch the manifest.");
    }

    private ApplicationLinkProviderInfoEntity getCloudProviderInfo(URI rpcUrl) throws ServiceException {
        URI providerInfoUrl = UriBuilder.fromUri((URI)rpcUrl).path("rest").path("applinks").path("latest").path("provider-info").build(new Object[0]);
        return this.getEntity(providerInfoUrl, ApplicationLinkProviderInfoEntity.class, "OAuth 2.0 Provider Info");
    }

    private CloudTenantInfoEntity getCloudTenantInfo(Manifest manifest) throws ServiceException {
        URI remoteUrl = manifest.getUrl();
        String url = remoteUrl.getPort() == -1 ? String.format("%s://%s", remoteUrl.getScheme(), remoteUrl.getHost()) : String.format("%s://%s:%s", remoteUrl.getScheme(), remoteUrl.getHost(), remoteUrl.getPort());
        URI tenantInfoEndpoint = UriBuilder.fromUri((String)url).path(CLOUD_TENANT_INFO_ENDPOINT).build(new Object[0]);
        return this.getEntity(tenantInfoEndpoint, CloudTenantInfoEntity.class, "Cloud ID");
    }

    private <T> T getEntity(URI url, Class<T> entityType, String resourceName) throws ServiceException {
        try {
            return (T)this.requestFactory.createRequest(Request.MethodType.GET, url.toString()).setConnectionTimeout(10000).setSoTimeout(10000).executeAndReturn(response -> {
                int statusCode = response.getStatusCode();
                if (statusCode >= 200 && statusCode <= 299) {
                    return response.getEntity(entityType);
                }
                throw new ResponseStatusException(resourceName + " error", response);
            });
        }
        catch (Exception e) {
            ResponseStatusException exception;
            int statusCode;
            LOG.error("Error fetching {}", (Object)resourceName, (Object)e);
            if (e instanceof ResponseStatusException && (statusCode = (exception = (ResponseStatusException)e).getResponse().getStatusCode()) >= 400 && statusCode <= 499) {
                throw this.serviceExceptionFactory.raise(InvalidRequestException.class, new Serializable[]{resourceName});
            }
            throw this.serviceExceptionFactory.raise(InvalidRequestException.class, new Serializable[]{String.format("%s (internal)", resourceName)});
        }
    }
}

