/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.helper;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.auth.AuthenticatorAccessor;
import com.atlassian.applinks.core.concurrent.ConcurrentExecutor;
import com.atlassian.applinks.core.rest.context.CurrentContext;
import com.atlassian.applinks.core.rest.model.ApplicationLinkEntity;
import com.atlassian.applinks.core.rest.model.LinkAndAuthProviderEntity;
import com.atlassian.applinks.core.rest.model.WebItemEntityList;
import com.atlassian.applinks.core.rest.model.WebPanelEntityList;
import com.atlassian.applinks.core.webfragment.WebFragmentContext;
import com.atlassian.applinks.core.webfragment.WebFragmentHelper;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.applinks.spi.auth.IncomingTrustAuthenticationProviderPluginModule;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.plugins.rest.api.model.Link;
import com.atlassian.plugins.rest.api.util.RestUrlBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AppLinkResourceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AppLinkResourceHelper.class);
    private final InternalHostApplication internalHostApplication;
    private final ManifestRetriever manifestRetriever;
    private final WebFragmentHelper webFragmentHelper;
    private final AuthenticatorAccessor authenticatorAccessor;
    private final ConcurrentExecutor executor;
    private final InternalTypeAccessor typeAccessor;
    private final MutatingApplicationLinkService applicationLinkService;

    @Autowired
    public AppLinkResourceHelper(MutatingApplicationLinkService applicationLinkService, InternalHostApplication internalHostApplication, ManifestRetriever manifestRetriever, I18nResolver i18nResolver, WebFragmentHelper webFragmentHelper, RestUrlBuilder restUrlBuilder, AuthenticatorAccessor authenticatorAccessor, InternalTypeAccessor typeAccessor, ConcurrentExecutor executor) {
        this.internalHostApplication = internalHostApplication;
        this.manifestRetriever = manifestRetriever;
        this.webFragmentHelper = webFragmentHelper;
        this.authenticatorAccessor = authenticatorAccessor;
        this.executor = executor;
        this.typeAccessor = typeAccessor;
        this.applicationLinkService = applicationLinkService;
    }

    public synchronized List<LinkAndAuthProviderEntity> retrieveLinkAndAuthProviderEntityList(Iterable<ApplicationLink> applinks) throws Exception {
        ArrayList<LinkAndAuthProviderEntity> links = new ArrayList<LinkAndAuthProviderEntity>();
        for (Future future : this.executor.invokeAll(this.createJobs(applinks))) {
            links.add((LinkAndAuthProviderEntity)future.get());
        }
        return Lists.newArrayList((Iterable)Iterables.filter(links, Objects::nonNull));
    }

    protected List<Callable<LinkAndAuthProviderEntity>> createJobs(Iterable<ApplicationLink> applicationLinks) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(applicationLinks, applicationLink -> new CurrentContextAwareCallable<LinkAndAuthProviderEntity>(){

            @Override
            public LinkAndAuthProviderEntity callWithContext() {
                try {
                    return AppLinkResourceHelper.this.getLinkAndAuthProviderEntity(applicationLink);
                }
                catch (Exception e) {
                    LOG.error("Cannot retrieve link and provider entity for {}", (Object)applicationLink);
                    LOG.debug("Exception: ", (Throwable)e);
                    return null;
                }
            }
        }));
    }

    protected LinkAndAuthProviderEntity getLinkAndAuthProviderEntity(ApplicationLink applicationLink) {
        LinkedHashSet<Class<? extends AuthenticationProvider>> configuredOutgoingAuthenticationProviders = new LinkedHashSet<Class<? extends AuthenticationProvider>>();
        LinkedHashSet<Class<? extends AuthenticationProvider>> configuredIncomingAuthenticationProviders = new LinkedHashSet<Class<? extends AuthenticationProvider>>();
        for (AuthenticationProviderPluginModule authenticationProviderPluginModule : this.authenticatorAccessor.getAllAuthenticationProviderPluginModules()) {
            IncomingTrustAuthenticationProviderPluginModule incomingTrustAuthenticationProviderPluginModule;
            AuthenticationProvider authenticationProvider = authenticationProviderPluginModule.getAuthenticationProvider(applicationLink);
            if (authenticationProvider != null) {
                configuredOutgoingAuthenticationProviders.add(authenticationProviderPluginModule.getAuthenticationProviderClass());
            }
            if (!(authenticationProviderPluginModule instanceof IncomingTrustAuthenticationProviderPluginModule) || !(incomingTrustAuthenticationProviderPluginModule = (IncomingTrustAuthenticationProviderPluginModule)authenticationProviderPluginModule).incomingEnabled(applicationLink)) continue;
            configuredIncomingAuthenticationProviders.add(authenticationProviderPluginModule.getAuthenticationProviderClass());
        }
        boolean hasIncomingAuthenticationProviders = true;
        boolean hasOutgoingAuthenticationProviders = true;
        try {
            Manifest manifest = this.manifestRetriever.getManifest(applicationLink.getRpcUrl(), applicationLink.getType());
            hasIncomingAuthenticationProviders = !Sets.intersection((Set)Sets.newHashSet((Iterable)this.internalHostApplication.getSupportedInboundAuthenticationTypes()), (Set)manifest.getOutboundAuthenticationTypes()).isEmpty();
            hasOutgoingAuthenticationProviders = !Sets.intersection((Set)Sets.newHashSet((Iterable)this.internalHostApplication.getSupportedOutboundAuthenticationTypes()), (Set)manifest.getInboundAuthenticationTypes()).isEmpty();
        }
        catch (ManifestNotFoundException manifest) {
            // empty catch block
        }
        WebFragmentContext context = new WebFragmentContext.Builder().applicationLink(applicationLink).build();
        WebItemEntityList webItems = this.webFragmentHelper.getWebItemsForLocation("applinks.application.link.list.operation", context);
        WebPanelEntityList webPanels = this.webFragmentHelper.getWebPanelsForLocation("applinks.application.link.list.operation", context);
        return new LinkAndAuthProviderEntity(this.toApplicationLinkEntity(applicationLink), configuredOutgoingAuthenticationProviders, configuredIncomingAuthenticationProviders, hasOutgoingAuthenticationProviders, hasIncomingAuthenticationProviders, webItems.getItems(), webPanels.getWebPanels(), this.getEntityTypeIdsForApplication(applicationLink), applicationLink.isSystem(), !StringUtils.isBlank((CharSequence)applicationLink.getClientId()));
    }

    private Set<String> getEntityTypeIdsForApplication(ApplicationLink applicationLink) {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)this.typeAccessor.getEnabledEntityTypesForApplicationType(applicationLink.getType()), from -> TypeId.getTypeId((EntityType)from).get()));
    }

    private ApplicationLinkEntity toApplicationLinkEntity(ApplicationLink appLink) {
        return new ApplicationLinkEntity(appLink, this.createSelfLinkFor(appLink.getId()));
    }

    private Link createSelfLinkFor(ApplicationId appID) {
        return Link.self((URI)this.applicationLinkService.createSelfLinkFor(appID));
    }

    private static abstract class CurrentContextAwareCallable<T>
    implements Callable<T> {
        private final UriInfo uriInfo = CurrentContext.getUriInfo();
        private final HttpServletRequest httpServletRequest = CurrentContext.getHttpServletRequest();

        private CurrentContextAwareCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T call() throws Exception {
            UriInfo oldUriInfo = CurrentContext.getUriInfo();
            HttpServletRequest oldRequest = CurrentContext.getHttpServletRequest();
            CurrentContext.setUriInfo(this.uriInfo);
            CurrentContext.setHttpServletRequest(this.httpServletRequest);
            try {
                T t = this.callWithContext();
                return t;
            }
            finally {
                CurrentContext.setUriInfo(oldUriInfo);
                CurrentContext.setHttpServletRequest(oldRequest);
            }
        }

        public abstract T callWithContext() throws Exception;
    }
}

