/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.common.lang;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;

public final class ApplinksEnums {
    private ApplinksEnums() {
    }

    @Nonnull
    public static <E extends Enum<E>> Function<String, E> fromNameFunction(@Nonnull Class<E> enumType) {
        return stringValue -> Enum.valueOf(enumType, stringValue);
    }

    @Nonnull
    public static <E extends Enum<E>> Function<String, E> fromNameSafeFunction(final @Nonnull Class<E> enumType) {
        return new Function<String, E>(){

            @Override
            @Nullable
            public E apply(@Nullable String stringValue) {
                try {
                    return (Enum)ApplinksEnums.fromNameFunction(enumType).apply(stringValue);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    return null;
                }
            }
        };
    }

    @Nonnull
    public static Function<Enum<?>, String> toNameFunction() {
        return Enum::name;
    }
}

