/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.common.web.data;

import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.internal.common.json.JacksonJsonableMarshaller;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;

public class PageInitializerDataProvider
implements WebResourceDataProvider {
    public static final String PARAM_PAGE_INITIALIZER = "pageInitializer";
    public static final String PARAM_PAGE_TYPE = "pageType";
    public static final String PARAM_PAGE_SIZE = "pageSize";
    private static final Set<String> BODY_CLASS_APPS = Set.of("refapp", "stash", "bamboo", "fecru");
    private final HttpContext httpContext;
    private final InternalHostApplication internalHostApplication;

    public PageInitializerDataProvider(HttpContext httpContext, InternalHostApplication internalHostApplication) {
        this.httpContext = httpContext;
        this.internalHostApplication = internalHostApplication;
    }

    public Jsonable get() {
        HttpServletRequest request = this.httpContext.getRequest();
        String pageInitializer = PageInitializerDataProvider.getPageInitializerFromRequest(request);
        BaseRestEntity.Builder entityBuilder = new BaseRestEntity.Builder().add(PARAM_PAGE_INITIALIZER, pageInitializer);
        if (BODY_CLASS_APPS.contains(this.internalHostApplication.getId().toString())) {
            entityBuilder.add(PARAM_PAGE_TYPE, request.getAttribute(PARAM_PAGE_TYPE)).add(PARAM_PAGE_SIZE, request.getAttribute(PARAM_PAGE_SIZE));
        }
        return JacksonJsonableMarshaller.INSTANCE.marshal((Object)entityBuilder.build());
    }

    private static String getPageInitializerFromRequest(HttpServletRequest request) {
        Object pageInitializer;
        if (request != null && (pageInitializer = request.getAttribute(PARAM_PAGE_INITIALIZER)) instanceof String) {
            return (String)pageInitializer;
        }
        return null;
    }
}

