/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.applink;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.oauth2.ApplinkOAuth2Service;
import com.atlassian.applinks.helper.AppLinkResourceHelper;
import com.atlassian.applinks.internal.applink.ApplinkHelper;
import com.atlassian.applinks.internal.applink.ApplinkValidationService;
import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.common.rest.model.applink.RestApplicationLink;
import com.atlassian.applinks.internal.common.rest.util.RestApplicationIdParser;
import com.atlassian.applinks.internal.feature.ApplinksFeatureService;
import com.atlassian.applinks.internal.feature.ApplinksFeatures;
import com.atlassian.applinks.internal.permission.PermissionValidationService;
import com.atlassian.applinks.internal.rest.applink.data.RestApplinkDataProviders;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.internal.rest.model.applink.RestExtendedApplicationLink;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="applinks")
@Singleton
@NoCacheHeaderFilterBinding
public class ApplicationLinkV3Resource {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLinkV3Resource.class);
    public static final String CONTEXT = "applinks";
    private final MutatingApplicationLinkService applicationLinkService;
    private final ApplinkHelper applinkHelper;
    private final ApplinkValidationService applinkValidationService;
    private final PermissionValidationService permissionValidationService;
    private final RestApplinkDataProviders dataProviders;
    private final RestApplicationIdParser restApplicationIdParser;
    private final ApplinkOAuth2Service applinkOAuth2Service;
    private final ApplinksFeatureService applinksFeatureService;
    private final AppLinkResourceHelper appLinkResourceHelper;

    @Inject
    public ApplicationLinkV3Resource(MutatingApplicationLinkService applicationLinkService, ApplinkHelper applinkHelper, ApplinkValidationService applinkValidationService, PermissionValidationService permissionValidationService, RestApplinkDataProviders dataProviders, RestApplicationIdParser restApplicationIdParser, ApplinkOAuth2Service applinkOAuth2Service, ApplinksFeatureService applinksFeatureService, AppLinkResourceHelper appLinkResourceHelper) {
        this.applicationLinkService = applicationLinkService;
        this.applinkHelper = applinkHelper;
        this.applinkValidationService = applinkValidationService;
        this.permissionValidationService = permissionValidationService;
        this.dataProviders = dataProviders;
        this.restApplicationIdParser = restApplicationIdParser;
        this.applinkOAuth2Service = applinkOAuth2Service;
        this.applinksFeatureService = applinksFeatureService;
        this.appLinkResourceHelper = appLinkResourceHelper;
    }

    @GET
    public Response getAll(@QueryParam(value="property") Set<String> propertyKeys, @QueryParam(value="data") Set<String> dataKeys) throws Exception {
        this.permissionValidationService.validateAdmin();
        Iterable<ApplicationLink> applicationLinks = this.filterOutUniconnLinks(this.applicationLinkService.getApplicationLinks());
        List oauth2Clients = this.applinksFeatureService.isEnabled(ApplinksFeatures.V4_UI) ? this.applinkOAuth2Service.getApplicationLinksForOAuth2Clients() : Collections.emptyList();
        List oauth2Providers = this.applinksFeatureService.isEnabled(ApplinksFeatures.V4_UI) ? this.applinkOAuth2Service.getApplicationLinksForOAuth2Provider() : Collections.emptyList();
        Iterable allApplicationLinks = Iterables.concat(applicationLinks, oauth2Clients, oauth2Providers);
        ImmutableList.Builder restApplinks = ImmutableList.builder();
        for (ApplicationLink applink : allApplicationLinks) {
            restApplinks.add((Object)new RestExtendedApplicationLink(applink, propertyKeys, this.dataProviders.getData(applink, dataKeys)));
        }
        return Response.ok((Object)restApplinks.build()).build();
    }

    @GET
    @Path(value="{applinkid}")
    public Response get(@PathParam(value="applinkid") String applinkId, @QueryParam(value="property") Set<String> propertyKeys, @QueryParam(value="data") Set<String> dataKeys) throws ServiceException {
        this.permissionValidationService.validateAdmin();
        ApplicationLink applink = this.applinkHelper.getApplicationLink(this.restApplicationIdParser.parse(applinkId));
        return Response.ok((Object)new RestExtendedApplicationLink(applink, propertyKeys, this.dataProviders.getData(applink, dataKeys))).build();
    }

    @PUT
    @Path(value="{applinkid}")
    public Response update(@PathParam(value="applinkid") String applinkId, RestApplicationLink restApplink) throws ServiceException {
        this.permissionValidationService.validateAdmin();
        ApplicationId id = this.restApplicationIdParser.parse(applinkId);
        ApplicationLinkDetails details = restApplink.toDetails();
        this.applinkValidationService.validateUpdate(id, details);
        if (details.isPrimary()) {
            this.applinkHelper.makePrimary(id);
        }
        MutableApplicationLink applink = this.applinkHelper.getMutableApplicationLink(id);
        applink.update(details);
        return Response.ok((Object)new RestApplicationLink((ApplicationLink)applink)).build();
    }

    @DELETE
    @Path(value="{applinkid}")
    public Response delete(@PathParam(value="applinkid") String applinkId) throws ServiceException {
        this.permissionValidationService.validateAdmin();
        ApplicationLink applink = this.applinkHelper.getApplicationLink(this.restApplicationIdParser.parse(applinkId));
        this.applicationLinkService.deleteApplicationLink(applink);
        return Response.noContent().build();
    }

    private Iterable<ApplicationLink> filterOutUniconnLinks(Iterable<ApplicationLink> links) {
        return Iterables.filter(links, link -> !UniconnApplinkUtils.isUniconnApplink(link));
    }
}

