/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.applink;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.ApplicationTypeVisitor;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.types.ThreeLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.core.rest.model.IncomingApplicationLinkDetails;
import com.atlassian.applinks.core.rest.model.IncomingApplinkInputEntity;
import com.atlassian.applinks.core.rest.model.IncomingClientUpdateEntity;
import com.atlassian.applinks.core.rest.model.OutgoingApplicationLinkDetails;
import com.atlassian.applinks.core.rest.model.OutgoingApplinkInputEntity;
import com.atlassian.applinks.core.rest.model.ProviderInfoModel;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.core.util.ApplicationLinkOAuth2Support;
import com.atlassian.applinks.core.util.AvailableScopesResolverHelper;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.internal.applink.ApplinkHelper;
import com.atlassian.applinks.internal.common.exception.ClientConfigurationNotFoundException;
import com.atlassian.applinks.internal.common.exception.ClientConfigurationScopesNotFoundException;
import com.atlassian.applinks.internal.common.exception.ClientNotFoundException;
import com.atlassian.applinks.internal.common.exception.InvalidApplicationIdException;
import com.atlassian.applinks.internal.common.exception.InvalidEmptyValueException;
import com.atlassian.applinks.internal.common.exception.InvalidRequestException;
import com.atlassian.applinks.internal.common.exception.InvalidValueException;
import com.atlassian.applinks.internal.common.exception.NoSuchApplinkException;
import com.atlassian.applinks.internal.common.exception.OAuth2NotSupportedException;
import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.common.exception.ServiceExceptionFactory;
import com.atlassian.applinks.internal.common.i18n.I18nKey;
import com.atlassian.applinks.internal.common.rest.util.RestApplicationIdParser;
import com.atlassian.applinks.internal.rest.applink.OAuth2ScopesAlowlist;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigStorageService;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.client.api.storage.config.ProviderType;
import com.atlassian.oauth2.client.api.storage.token.exception.ConfigurationNotFoundException;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.scopes.api.InvalidScopeException;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="oauth2/applinks")
@Singleton
@NoCacheHeaderFilterBinding
public class OAuth2ApplicationLinksResource {
    public static final String CONTEXT = "oauth2/applinks";
    private static final Logger log = LoggerFactory.getLogger(OAuth2ApplicationLinksResource.class);
    private final ScopeResolver scopeResolver;
    private final ClientService clientService;
    private final MutatingApplicationLinkService applicationLinkService;
    private final TypeAccessor typeAccessor;
    private final ApplinkHelper applinkHelper;
    private final RestApplicationIdParser restApplicationIdParser;
    private final ApplicationLinkOAuth2Support oAuth2Support;
    private final I18nResolver i18nResolver;
    private final ClientConfigStorageService clientConfigStorageService;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ServiceExceptionFactory serviceExceptionFactory;
    private final AvailableScopesResolverHelper availableScopesResolverHelper;
    private final InternalHostApplication internalHostApplication;

    @Inject
    public OAuth2ApplicationLinksResource(ScopeResolver scopeResolver, ClientService clientService, MutatingApplicationLinkService applicationLinkService, TypeAccessor typeAccessor, ApplinkHelper applinkHelper, RestApplicationIdParser restApplicationIdParser, ApplicationLinkOAuth2Support oAuth2Support, I18nResolver i18nResolver, ClientConfigStorageService clientConfigStorageService, AuthenticationConfigurationManager authenticationConfigurationManager, ServiceExceptionFactory serviceExceptionFactory, AvailableScopesResolverHelper availableScopesResolverHelper, InternalHostApplication internalHostApplication) {
        this.scopeResolver = scopeResolver;
        this.clientService = clientService;
        this.applicationLinkService = applicationLinkService;
        this.typeAccessor = typeAccessor;
        this.applinkHelper = applinkHelper;
        this.restApplicationIdParser = restApplicationIdParser;
        this.oAuth2Support = oAuth2Support;
        this.i18nResolver = i18nResolver;
        this.clientConfigStorageService = clientConfigStorageService;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.serviceExceptionFactory = serviceExceptionFactory;
        this.availableScopesResolverHelper = availableScopesResolverHelper;
        this.internalHostApplication = internalHostApplication;
    }

    @GET
    public Response getIncomingInitialDetails(@QueryParam(value="rpc.url") String rpcUrlString, @QueryParam(value="display.url") String displayUrl) throws ManifestNotFoundException, TypeNotInstalledException, OAuth2NotSupportedException {
        if (rpcUrlString == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'rpc.url' is required").build();
        }
        URI rpcUrl = URI.create(rpcUrlString);
        Manifest manifest = this.oAuth2Support.getManifest(rpcUrl);
        this.getApplicationType(manifest, rpcUrl);
        RedirectUri redirectUri = this.getRedirectUri(manifest, null);
        return Response.ok((Object)new IncomingApplicationLinkDetails(manifest.getId().toString(), manifest.getName(), rpcUrl.toString(), displayUrl, redirectUri.redirectUrl(), redirectUri.readOnlyRedirectUri(), this.getAvailableIncomingScopes(this.internalHostApplication.getType()), null, null, null)).build();
    }

    @POST
    public Response createIncomingApplicationLink(@RequestBody IncomingApplinkInputEntity input) throws ManifestNotFoundException, TypeNotInstalledException, ServiceException {
        this.validateScope(input.getIncomingScopes());
        URI rpcUrl = URI.create(input.getRpcUrl());
        Manifest manifest = this.oAuth2Support.getManifest(rpcUrl);
        ApplicationType applicationType = this.getApplicationType(manifest, rpcUrl);
        ApplicationId applicationId = manifest.getId();
        if (this.applicationLinkService.getApplicationLink(applicationId) != null) {
            return RestUtil.badRequest(this.i18nResolver.getText("applinks.error.duplicate.url", new Serializable[]{rpcUrl}));
        }
        RedirectUri redirectUri = this.getRedirectUri(manifest, input.getIncomingRedirectUri());
        this.validateUri(redirectUri.redirectUrl);
        String clientName = String.format("Client %s-%s", manifest.getName(), applicationId.get());
        Client client = this.clientService.create(clientName, this.scopeResolver.getScope(input.getIncomingScopes()), List.of(redirectUri.redirectUrl));
        MutableApplicationLink applicationLink = this.applicationLinkService.addApplicationLink(applicationId, applicationType, this.buildApplicationLinkDetails(input, client, manifest));
        String incomingClientEntityId = applicationLink.getClientId();
        String incomingClientId = incomingClientEntityId != null ? client.getClientId() : null;
        String incomingRedirectUri = incomingClientEntityId != null ? (String)client.getRedirects().stream().findFirst().orElse(null) : null;
        String incomingClientSecret = incomingClientEntityId != null ? client.getClientSecret() : null;
        String incomingScopes = incomingClientEntityId != null ? client.getScope().getName() : null;
        return Response.ok((Object)new IncomingApplicationLinkDetails(applicationLink.getId().get(), applicationLink.getName(), applicationLink.getRpcUrl().toString(), applicationLink.getDisplayUrl().toString(), incomingRedirectUri, redirectUri.readOnlyRedirectUri, null, incomingScopes, incomingClientId, incomingClientSecret)).build();
    }

    @GET
    @Path(value="{id}/incoming")
    public Response getIncomingDetails(@PathParam(value="id") String applinkId, @QueryParam(value="edit") @DefaultValue(value="false") boolean edit) throws OAuth2NotSupportedException, ClientNotFoundException, InvalidApplicationIdException, NoSuchApplinkException {
        ApplicationLink applicationLink = this.applinkHelper.getApplicationLink(this.restApplicationIdParser.parse(applinkId));
        if (StringUtils.isBlank((CharSequence)applicationLink.getClientId())) {
            throw new OAuth2NotSupportedException("OAuth2 is not supported for the remote application.");
        }
        Client client = (Client)this.clientService.getById(applicationLink.getClientId()).orElseThrow(() -> new ClientNotFoundException("Client not found"));
        String incomingRedirectUri = client.getRedirects().stream().findFirst().orElse(null);
        Boolean readonlyRedirectUri = edit ? Boolean.valueOf(applicationLink.isCloud()) : null;
        List<String> availableScopes = edit ? this.getAvailableIncomingScopes(this.internalHostApplication.getType()) : null;
        return Response.ok((Object)new IncomingApplicationLinkDetails(applicationLink.getId().get(), applicationLink.getName(), applicationLink.getRpcUrl().toString(), applicationLink.getDisplayUrl().toString(), incomingRedirectUri, readonlyRedirectUri, availableScopes, client.getScope().getName(), client.getClientId(), client.getClientSecret())).build();
    }

    @PUT
    @Path(value="{id}/incoming")
    public Response updateIncomingDetails(@PathParam(value="id") String applinkId, @RequestBody IncomingClientUpdateEntity input) throws ServiceException {
        this.validateScopeIfNotBlank(input.getIncomingScopes());
        ApplicationLink applicationLink = this.applinkHelper.getApplicationLink(this.restApplicationIdParser.parse(applinkId));
        if (StringUtils.isBlank((CharSequence)applicationLink.getClientId())) {
            throw new ClientNotFoundException("Client not found");
        }
        String redirectUri = input.getIncomingRedirectUri();
        if (StringUtils.isNotBlank((CharSequence)redirectUri) && !applicationLink.isCloud()) {
            this.validateUri(redirectUri);
        } else {
            redirectUri = null;
        }
        this.clientService.updateClient(applicationLink.getClientId(), null, input.getIncomingScopes(), redirectUri != null ? List.of(redirectUri) : Collections.emptyList()).orElseThrow();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="{id}/outgoing")
    public Response getOutgoingDetails(@PathParam(value="id") String id) throws ServiceException {
        OutgoingApplicationLinkDetails details;
        ApplicationLink applicationLink = this.applinkHelper.getApplicationLink(this.restApplicationIdParser.parse(id));
        boolean readonlyOutgoingScopes = applicationLink.isCloud();
        ProviderInfoModel providerInfo = this.oAuth2Support.getProviderInfo(applicationLink.getRpcUrl());
        String redirectUri = this.getRedirectUri(providerInfo);
        ArrayList<String> availableOutgoingScopes = new ArrayList<String>(providerInfo.scopesSupported());
        boolean outgoingPresent = StringUtils.isNotBlank((CharSequence)applicationLink.getAuthorizationCodeClientConfigurationId());
        ClientConfigurationEntity clientConfiguration = outgoingPresent ? (ClientConfigurationEntity)this.clientConfigStorageService.getById(applicationLink.getAuthorizationCodeClientConfigurationId()).orElse(null) : null;
        String applicationId = applicationLink.getId().get();
        String name = applicationLink.getName();
        if (clientConfiguration != null) {
            String clientId = clientConfiguration.getClientId();
            String clientSecret = clientConfiguration.getClientSecret();
            List outgoingScopes = clientConfiguration.getScopes();
            boolean outgoingDataIsStale = !providerInfo.authorizationEndpoint().equals(clientConfiguration.getAuthorizationEndpoint()) || !providerInfo.tokenEndpoint().equals(clientConfiguration.getTokenEndpoint());
            details = new OutgoingApplicationLinkDetails(applicationId, name, clientId, clientSecret, redirectUri, availableOutgoingScopes, outgoingScopes, outgoingPresent, outgoingDataIsStale, readonlyOutgoingScopes);
        } else {
            details = new OutgoingApplicationLinkDetails(applicationId, name, null, null, redirectUri, availableOutgoingScopes, Collections.emptyList(), outgoingPresent, true, readonlyOutgoingScopes);
        }
        return Response.ok((Object)details).build();
    }

    @PUT
    @Path(value="{id}/outgoing")
    public Response updateOutgoingDetails(@PathParam(value="id") String id, @RequestBody OutgoingApplinkInputEntity input) throws ConfigurationNotFoundException, ServiceException, ManifestNotFoundException {
        MutableApplicationLink applicationLink = this.applinkHelper.getMutableApplicationLink(this.restApplicationIdParser.parse(id));
        ProviderInfoModel providerInfo = this.oAuth2Support.getProviderInfo(applicationLink.getRpcUrl());
        if (applicationLink.isCloud() && !this.hasSameScopes(input.getOutgoingScopes(), providerInfo.scopesSupported())) {
            log.warn("The scopes should not be changed if it is the Cloud AppLink; therefore, use the same supported scopes from the provider information.");
            input.setOutgoingScopes(providerInfo.scopesSupported().stream().toList());
        }
        ClientConfigurationEntity authorizationCode = this.saveClientConfig(applicationLink.getAuthorizationCodeClientConfigurationId(), GrantType.AUTHORIZATION_CODE_GRANT, applicationLink, input, providerInfo);
        ClientConfigurationEntity clientCredentials = this.saveClientConfig(applicationLink.getClientCredentialsClientConfigurationId(), GrantType.CLIENT_CREDENTIALS_GRANT, applicationLink, input, providerInfo);
        ApplicationLinkDetails details = ApplicationLinkDetails.builder((ApplicationLink)applicationLink).rpcUrl(providerInfo.rpcUrl()).authorizationCodeClientConfigurationId(authorizationCode.getId()).clientCredentialsClientConfigurationId(clientCredentials.getId()).build();
        applicationLink.update(details);
        this.registerAuthenticationProviders(applicationLink);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") String id) throws ServiceException {
        ApplicationLink link = this.applinkHelper.getApplicationLink(this.restApplicationIdParser.parse(id));
        this.applicationLinkService.deleteApplicationLink(link);
        return Response.noContent().build();
    }

    private String getRedirectUri(ProviderInfoModel providerInfo) throws InvalidRequestException {
        try {
            return this.clientConfigStorageService.generateRedirectUrl(providerInfo.authorizationEndpoint());
        }
        catch (Exception e) {
            log.warn("Unable to generate outgoing application link, an error occurred.", (Throwable)e);
            throw new InvalidRequestException("Unable to generate outgoing application link, an error occurred.", e);
        }
    }

    private RedirectUri getRedirectUri(Manifest manifest, String defaultRedirectUri) {
        if (ApplicationLinkOAuth2Support.isCloud(manifest) && manifest.getRedirectUrl() != null) {
            return new RedirectUri(manifest.getRedirectUrl().toString(), true);
        }
        return new RedirectUri(defaultRedirectUri, false);
    }

    private ApplicationType getApplicationType(Manifest manifest, URI rpcUrl) throws TypeNotInstalledException {
        ApplicationType applicationType = this.typeAccessor.loadApplicationType(manifest.getTypeId());
        if (applicationType == null) {
            log.warn("Couldn't load type {} for application link. Type is not installed?", (Object)manifest.getTypeId());
            throw new TypeNotInstalledException(manifest.getTypeId().get(), manifest.getName(), rpcUrl);
        }
        return applicationType;
    }

    private boolean hasSameScopes(List<String> outgoingScopes, Set<String> supportedScopes) {
        if (outgoingScopes.size() != supportedScopes.size()) {
            return false;
        }
        HashSet<String> outgoingSet = new HashSet<String>(outgoingScopes);
        return outgoingSet.equals(supportedScopes);
    }

    private ClientConfigurationEntity saveClientConfig(String configId, GrantType grantType, MutableApplicationLink applicationLink, OutgoingApplinkInputEntity input, ProviderInfoModel providerInfo) throws ConfigurationNotFoundException, ServiceException {
        ClientConfigurationEntity entity;
        if (StringUtils.isNotBlank((CharSequence)configId)) {
            Optional config = this.clientConfigStorageService.getById(configId);
            if (config.isEmpty()) {
                throw new ClientConfigurationNotFoundException("Client configuration not found");
            }
            entity = this.updateClientConfig((ClientConfigurationEntity)config.get(), input, providerInfo);
        } else {
            entity = this.createClientConfig((ApplicationLink)applicationLink, input, providerInfo, grantType);
        }
        return this.clientConfigStorageService.save(entity);
    }

    private ClientConfigurationEntity createClientConfig(ApplicationLink applicationLink, OutgoingApplinkInputEntity input, ProviderInfoModel providerInfo, GrantType grantType) throws ServiceException {
        String clientId = input.getOutgoingClientId();
        String clientSecret = input.getOutgoingClientSecret();
        List<String> scopes = input.getOutgoingScopes();
        return this.buildClientConfig(null, String.format("%s (%s)", applicationLink.getName(), grantType.getName().toLowerCase()), clientId, clientSecret, scopes, grantType, providerInfo);
    }

    private ClientConfigurationEntity updateClientConfig(ClientConfigurationEntity existingConfig, OutgoingApplinkInputEntity input, ProviderInfoModel providerInfo) throws ServiceException {
        assert (existingConfig.getId() != null);
        String clientId = this.updateValue(existingConfig.getClientId(), input.getOutgoingClientId());
        String clientSecret = this.updateValue(existingConfig.getClientSecret(), input.getOutgoingClientSecret());
        List<String> scopes = input.getOutgoingScopes();
        return this.buildClientConfig(existingConfig.getId(), existingConfig.getName(), clientId, clientSecret, scopes, existingConfig.getGrantType(), providerInfo);
    }

    private ClientConfigurationEntity buildClientConfig(String id, String name, String clientId, String clientSecret, List<String> scopes, GrantType grantType, ProviderInfoModel providerInfo) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)name)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"Client configuration name"});
        }
        if (StringUtils.isBlank((CharSequence)clientId)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"Client ID"});
        }
        if (StringUtils.isBlank((CharSequence)clientSecret)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"Client Secret"});
        }
        if (clientId.length() > 450) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.toolong", new Serializable[]{"Client ID"}));
        }
        if (clientSecret.length() > 450) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.toolong", new Serializable[]{"Client Secret"}));
        }
        if (scopes == null || scopes.isEmpty()) {
            throw this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"Scopes"});
        }
        for (String scope : scopes) {
            if (scope.length() <= 450) continue;
            this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.toolong", new Serializable[]{"Scope"}));
        }
        if (!providerInfo.scopesSupported().containsAll(scopes)) {
            this.serviceExceptionFactory.raise(ClientConfigurationScopesNotFoundException.class, new Serializable[0]);
        }
        assert (grantType == GrantType.AUTHORIZATION_CODE_GRANT || grantType == GrantType.CLIENT_CREDENTIALS_GRANT);
        assert (StringUtils.isNotBlank((CharSequence)providerInfo.authorizationEndpoint()));
        assert (StringUtils.isNotBlank((CharSequence)providerInfo.tokenEndpoint()));
        return ClientConfigurationEntity.builder().id(id).name(name).grantType(grantType).providerType(ProviderType.GENERIC).clientId(clientId).clientSecret(clientSecret).authorizationEndpoint(providerInfo.authorizationEndpoint()).tokenEndpoint(providerInfo.tokenEndpoint()).scopes(scopes).customParams(providerInfo.customParams()).build();
    }

    private void registerAuthenticationProviders(MutableApplicationLink applicationLink) {
        Class<ThreeLeggedOAuth2AuthenticationProvider> authorizationCodeProvider = ThreeLeggedOAuth2AuthenticationProvider.class;
        if (!this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), authorizationCodeProvider)) {
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), authorizationCodeProvider, Collections.emptyMap());
        }
        boolean isClientCredentialsSupported = this.oAuth2Support.isOAuth2ClientCredentialsSupported(applicationLink.getRpcUrl());
        Class<TwoLeggedOAuth2AuthenticationProvider> clientCredentialsProvider = TwoLeggedOAuth2AuthenticationProvider.class;
        if (isClientCredentialsSupported && !this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), clientCredentialsProvider)) {
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), clientCredentialsProvider, Collections.emptyMap());
        }
    }

    private ApplicationLinkDetails buildApplicationLinkDetails(IncomingApplinkInputEntity input, Client client, Manifest manifest) throws InvalidEmptyValueException {
        String name = manifest.getName();
        String displayUrl = input.getDisplayUrl();
        String rpcUrl = input.getRpcUrl();
        String clientEntityId = client.getId();
        boolean isCloud = ApplicationLinkOAuth2Support.isCloud(manifest);
        if (StringUtils.isBlank((CharSequence)name)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"Application link name"});
        }
        if (StringUtils.isBlank((CharSequence)displayUrl)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"Display URL"});
        }
        if (StringUtils.isBlank((CharSequence)rpcUrl)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"RPC URL"});
        }
        if (StringUtils.isBlank((CharSequence)clientEntityId)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"Client ID"});
        }
        return ApplicationLinkDetails.builder().name(name).displayUrl(URI.create(displayUrl)).rpcUrl(URI.create(rpcUrl)).isPrimary(true).clientId(clientEntityId).authorizationCodeClientConfigurationId(null).clientCredentialsClientConfigurationId(null).isCloud(isCloud).build();
    }

    private List<String> getAvailableIncomingScopes(ApplicationType applicationType) {
        Set<String> availableScopes = this.scopeResolver.getAvailableScopes().stream().map(Scope::getName).collect(Collectors.toSet());
        OAuth2ScopesAlowlist visitor = new OAuth2ScopesAlowlist(availableScopes);
        List availableIncomingScopes = (List)applicationType.accept((ApplicationTypeVisitor)visitor);
        if (availableIncomingScopes == null) {
            return this.scopeResolver.getAvailableScopes().stream().map(Scope::getName).toList();
        }
        return this.availableScopesResolverHelper.getFilteredAvailableScopes(availableIncomingScopes);
    }

    private void validateUri(String uriString) throws InvalidValueException {
        if (uriString.length() >= 450) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.toolong", new Serializable[]{"redirectUri"}));
        }
        try {
            URI.create(uriString);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, new Serializable[]{"Redirect URI", "valid URL", uriString});
        }
    }

    private void validateScope(String scopeName) throws ServiceException {
        if (scopeName.length() >= 450) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.toolong", new Serializable[]{"scopeName"}));
        }
        try {
            this.scopeResolver.getScope(scopeName);
        }
        catch (InvalidScopeException e) {
            throw new ClientConfigurationScopesNotFoundException("Scopes not found", e);
        }
    }

    private void validateScopeIfNotBlank(String scopeName) throws ServiceException {
        if (scopeName == null || scopeName.isEmpty()) {
            return;
        }
        this.validateScope(scopeName);
    }

    private String updateValue(String oldValue, String newValue) {
        if (newValue == null || newValue.isEmpty() || newValue.equals(oldValue)) {
            return oldValue;
        }
        return newValue;
    }

    public record RedirectUri(String redirectUrl, boolean readOnlyRedirectUri) {
    }
}

