/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.applink;

import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.ApplicationTypeVisitor;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.application.bitbucket.BitbucketApplicationType;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.applinks.api.application.crowd.CrowdApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.generic.GenericApplicationType;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.application.refapp.RefAppApplicationType;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class OAuth2ScopesAlowlist
implements ApplicationTypeVisitor<List<String>> {
    private static final Predicate<String> DEFAULT_FILTER = s -> !s.equals("ADMIN") && !s.equals("SYSTEM_ADMIN");
    private static final Set<String> JIRA_ALLOWLISTED_SCOPES = Set.of("READ", "READ_ALL", "WRITE", "MANAGE_SUBSCRIPTIONS", "JSM_KB");
    private static final Set<String> CONFLUENCE_ALLOWLISTED_SCOPES = Set.of("READ", "READ_ALL", "WRITE", "MANAGE_SUBSCRIPTIONS", "JSM_KB");
    private static final Set<String> BITBUCKET_ALLOWLISTED_SCOPES = Set.of("PUBLIC_REPOS", "ACCOUNT_WRITE", "REPO_READ", "REPO_WRITE", "REPO_ADMIN", "PROJECT_ADMIN");
    private static final Set<String> BAMBOO_ALLOWLISTED_SCOPES = Set.of("READ", "READ_ALL", "TRIGGER", "USER");
    private static final Set<String> CROWD_ALLOWLISTED_SCOPES = Set.of("USER");
    private final Set<String> availableScopes;

    public OAuth2ScopesAlowlist(Set<String> availableScopes) {
        this.availableScopes = availableScopes;
    }

    public List<String> visit(@Nonnull BambooApplicationType type) {
        return this.filterAvailableScopes(BAMBOO_ALLOWLISTED_SCOPES::contains);
    }

    public List<String> visit(@Nonnull BitbucketApplicationType type) {
        return this.filterAvailableScopes(BITBUCKET_ALLOWLISTED_SCOPES::contains);
    }

    public List<String> visit(@Nonnull ConfluenceApplicationType type) {
        return this.filterAvailableScopes(CONFLUENCE_ALLOWLISTED_SCOPES::contains);
    }

    public List<String> visit(@Nonnull CrowdApplicationType type) {
        return this.filterAvailableScopes(CROWD_ALLOWLISTED_SCOPES::contains);
    }

    public List<String> visit(@Nonnull FishEyeCrucibleApplicationType type) {
        return this.filterAvailableScopes(DEFAULT_FILTER);
    }

    public List<String> visit(@Nonnull GenericApplicationType type) {
        return this.filterAvailableScopes(DEFAULT_FILTER);
    }

    public List<String> visit(@Nonnull JiraApplicationType type) {
        return this.filterAvailableScopes(JIRA_ALLOWLISTED_SCOPES::contains);
    }

    public List<String> visit(@Nonnull RefAppApplicationType type) {
        return this.filterAvailableScopes(DEFAULT_FILTER);
    }

    public List<String> visitDefault(@Nonnull ApplicationType applicationType) {
        return this.filterAvailableScopes(DEFAULT_FILTER);
    }

    private List<String> filterAvailableScopes(Predicate<String> filter) {
        return this.availableScopes.stream().filter(filter).toList();
    }
}

