/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.applink.data;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.rest.applink.data.AbstractSingleKeyRestApplinkDataProvider;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientExpirationEvaluator;
import com.atlassian.oauth2.provider.api.client.ClientService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OAuth2DataProvider
extends AbstractSingleKeyRestApplinkDataProvider {
    private static final Logger log = LoggerFactory.getLogger(OAuth2DataProvider.class);
    private static final String CLIENT_ENTITY_ID = "clientEntityId";
    private static final String CLIENT_ID = "clientId";
    private static final String ROTATED_CLIENT_ID = "rotatedClientId";
    private static final String CLIENT_EXPIRY_DATE = "expiryDate";
    private static final String CLIENT_SOON_EXPIRES = "soonExpires";
    private static final String SOON_TO_EXPIRE_PROPERTY_KEY = "troubleshooting.healthcheck.client.credentials.soon.to.expire.in.days";
    private static final int DEFAULT_SOON_TO_EXPIRE_IN_DAYS = 14;
    private final ClientService clientService;
    private final ClientExpirationEvaluator clientExpirationEvaluator;

    @Autowired
    public OAuth2DataProvider(ClientService clientService, ClientExpirationEvaluator clientExpirationEvaluator) {
        super(CLIENT_ENTITY_ID);
        this.clientService = clientService;
        this.clientExpirationEvaluator = clientExpirationEvaluator;
    }

    @Override
    @Nullable
    public Object doProvide(@Nonnull ApplicationLink applink) {
        Oauth2DataMap oauth2DataMap = new Oauth2DataMap();
        try {
            String clientEntityId = applink.getClientId();
            oauth2DataMap.put(CLIENT_ENTITY_ID, applink.getClientId());
            if (clientEntityId != null && !clientEntityId.isBlank()) {
                this.clientService.getById(clientEntityId).ifPresent(client -> {
                    oauth2DataMap.put(CLIENT_ID, client.getClientId());
                    oauth2DataMap.put(ROTATED_CLIENT_ID, client.getRotatedClientId());
                    oauth2DataMap.put(CLIENT_EXPIRY_DATE, this.convertDateTimeToString(this.getClientExpiryDate((Client)client)));
                    oauth2DataMap.put(CLIENT_SOON_EXPIRES, this.clientExpirationEvaluator.hasSoonToExpireLimitBreached(client, this.getSoonToExpireThreshold()));
                });
            }
        }
        catch (Throwable ex) {
            log.error("Error getting OAuth2 data for applink with id {}", (Object)applink.getId(), (Object)ex);
        }
        return oauth2DataMap;
    }

    private LocalDateTime getClientExpiryDate(Client client) {
        return Instant.ofEpochMilli(client.getCreatedDate()).plusSeconds(client.getExpiryDuration() != null ? client.getExpiryDuration().getSeconds() : this.clientExpirationEvaluator.getDefaultClientCredentialExpiry()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private Duration getSoonToExpireThreshold() {
        String soonToExpireProp = System.getProperty(SOON_TO_EXPIRE_PROPERTY_KEY);
        try {
            int soonToExpireInDays = soonToExpireProp != null ? Integer.parseInt(soonToExpireProp) : 14;
            return Duration.ofDays(soonToExpireInDays);
        }
        catch (NumberFormatException e) {
            return Duration.ofDays(14L);
        }
    }

    @Nullable
    private String convertDateTimeToString(@Nullable LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd, yyyy");
        return localDateTime != null ? localDateTime.format(formatter) : null;
    }

    public static class Oauth2DataMap
    extends HashMap<String, Object> {
    }
}

