/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.applink.data;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.rest.applink.data.RestApplinkDataProvider;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RestApplinkDataProviders {
    private static final Logger log = LoggerFactory.getLogger(RestApplinkDataProviders.class);
    final Map<String, RestApplinkDataProvider> providers;

    @Autowired
    public RestApplinkDataProviders(List<RestApplinkDataProvider> providers) {
        this.providers = this.mapProviders(providers);
    }

    private Map<String, RestApplinkDataProvider> mapProviders(Iterable<RestApplinkDataProvider> providers) {
        ImmutableMap.Builder mappedProviders = ImmutableMap.builder();
        for (RestApplinkDataProvider provider : providers) {
            for (String key : provider.getSupportedKeys()) {
                mappedProviders.put((Object)key, (Object)provider);
            }
        }
        return mappedProviders.build();
    }

    public RestApplinkDataProvider getProvider(@Nonnull String key) {
        return this.providers.get(key);
    }

    @Nonnull
    public Map<String, Object> getData(ApplicationLink applink, Set<String> dataKeys) throws ServiceException {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (String key : dataKeys) {
            RestApplinkDataProvider provider = this.getProvider(key);
            if (provider != null) {
                data.put(key, provider.provide(key, applink));
                continue;
            }
            log.debug("RestApplinkDataProvider for requested key {} not found", (Object)key);
            data.put(key, null);
        }
        return data;
    }
}

