/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.interceptor;

import com.atlassian.applinks.internal.rest.interceptor.CorsFilterBinding;
import com.atlassian.plugins.rest.api.internal.security.cors.CorsHeaders;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
@CorsFilterBinding
public class CorsFilter
implements ContainerResponseFilter {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TRUE = String.valueOf(true);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        this.addCorsHeaders(requestContext, responseContext);
    }

    private void addCorsHeaders(ContainerRequestContext request, ContainerResponseContext response) {
        String origin = request.getHeaderString(CorsHeaders.ORIGIN.value());
        response.getHeaders().put((Object)CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.value(), Collections.singletonList(origin));
        this.logger.debug("CORS Header [{}] set to [{}]", (Object)CorsHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS.value(), (Object)origin);
        response.getHeaders().put((Object)CorsHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS.value(), Collections.singletonList(TRUE));
        this.logger.debug("CORS Header [{}] set to [{}]", (Object)CorsHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS.value(), (Object)TRUE);
        if (this.isCorsPreflightRequest(request)) {
            response.getHeaders().put((Object)CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS.value(), Collections.singletonList(CONTENT_TYPE));
            this.logger.debug("CORS Preflight Header [{}] set to [{}]", (Object)CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS.value(), (Object)CONTENT_TYPE);
            response.getHeaders().put((Object)CorsHeaders.ACCESS_CONTROL_ALLOW_METHODS.value(), Collections.singletonList(request.getMethod()));
            this.logger.debug("CORS Preflight Header [{}] set to [{}]", (Object)CorsHeaders.ACCESS_CONTROL_ALLOW_METHODS.value(), (Object)request.getMethod());
        }
    }

    private boolean isCorsPreflightRequest(ContainerRequestContext requestContext) {
        Object preflightValue = requestContext.getProperty("Cors-Preflight-Requested");
        return TRUE.equals(preflightValue);
    }
}

