/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.migration;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.common.capabilities.RemoteApplicationCapabilities;
import com.atlassian.applinks.internal.common.capabilities.RemoteCapabilitiesService;
import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.common.rest.util.RestApplicationIdParser;
import com.atlassian.applinks.internal.migration.AuthenticationMigrationService;
import com.atlassian.applinks.internal.migration.AuthenticationStatus;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.internal.rest.model.migration.RestAuthenticationStatus;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="migration")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Singleton
@AnonymousSiteAccess
@WebSudoRequired
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
public class MigrateAuthenticationResource {
    public static final String CONTEXT = "migration";
    private final AuthenticationMigrationService migrationService;
    private final RemoteCapabilitiesService remoteCapabilitiesService;
    private final RestApplicationIdParser applicationIdParser;

    @Inject
    public MigrateAuthenticationResource(AuthenticationMigrationService authenticationMigrationService, RemoteCapabilitiesService remoteCapabilitiesService, RestApplicationIdParser applicationIdParser) {
        this.migrationService = authenticationMigrationService;
        this.applicationIdParser = applicationIdParser;
        this.remoteCapabilitiesService = remoteCapabilitiesService;
    }

    @POST
    @Path(value="{id}")
    public Response migrate(@PathParam(value="id") String id) throws ServiceException {
        ApplicationId applicationId = this.applicationIdParser.parse(id);
        AuthenticationStatus configs = this.migrationService.migrateToOAuth(applicationId);
        RemoteApplicationCapabilities remoteCapabilities = this.remoteCapabilitiesService.getCapabilities(applicationId);
        return RestUtil.ok(new RestAuthenticationStatus(configs, remoteCapabilities));
    }
}

