/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.model.auth.compatibility;

import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.function.Function;

public class RestAuthenticationProvider
extends BaseRestEntity {
    public static final Function<Object, RestAuthenticationProvider> REST_TRANSFORM_FUNCTION = new Function<Object, RestAuthenticationProvider>(){

        @Override
        @Nullable
        public RestAuthenticationProvider apply(@Nullable Object object) {
            return RestAuthenticationProvider.getAuthenticationProvider(object);
        }
    };
    public static final String MODULE = "module";
    public static final String PROVIDER = "provider";
    public static final String CONFIG = "config";

    public RestAuthenticationProvider() {
    }

    public RestAuthenticationProvider(@Nonnull Class<? extends AuthenticationProvider> clazz) {
        this.put(PROVIDER, (Object)clazz.getCanonicalName());
        this.put(CONFIG, (Object)new BaseRestEntity());
    }

    public RestAuthenticationProvider(Map<String, Object> original) {
        super(original);
    }

    @Nullable
    public String getProvider() {
        return this.getString(PROVIDER);
    }

    private static RestAuthenticationProvider getAuthenticationProvider(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RestAuthenticationProvider) {
            return (RestAuthenticationProvider)object;
        }
        if (object instanceof Map) {
            return new RestAuthenticationProvider((Map)object);
        }
        throw new IllegalArgumentException("Cannot instantiate RestAuthenticationProvider from " + String.valueOf(object));
    }
}

