/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.uniconn;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.common.rest.util.RestResponses;
import com.atlassian.applinks.internal.rest.applink.data.RestApplinkDataProviders;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.internal.rest.model.applink.RestExtendedApplicationLink;
import com.atlassian.applinks.internal.rest.model.uniconn.CreateBackboneApplicationLinkRequest;
import com.atlassian.applinks.internal.rest.model.uniconn.DisableBackboneResponseDto;
import com.atlassian.applinks.internal.rest.uniconn.exception.CannotDisableBackboneException;
import com.atlassian.applinks.internal.rest.uniconn.filter.UniconnFeatureFilterBinding;
import com.atlassian.applinks.internal.uniconn.BackboneConnectionService;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="uniconn/backbone-applinks")
@Singleton
@NoCacheHeaderFilterBinding
@UniconnFeatureFilterBinding
public class BackboneApplicationLinkResource {
    public static final String CONTEXT = "uniconn/backbone-applinks";
    private final BackboneConnectionService backboneApplinkService;
    private final RestApplinkDataProviders dataProviders;
    private final I18nResolver i18nResolver;
    private static final Set<String> DEFAULT_APPLINK_PROPERTY_KEYS = Set.of(UniconnApplinkProperties.ORG_NAME.key(), UniconnApplinkProperties.ORG_ID.key(), UniconnApplinkProperties.CREDENTIALS_EXPIRY.key(), UniconnApplinkProperties.CONNECTION_STATUS.key());

    @Inject
    BackboneApplicationLinkResource(BackboneConnectionService backboneApplinkService, RestApplinkDataProviders dataProviders, I18nResolver i18nResolver) {
        this.backboneApplinkService = backboneApplinkService;
        this.dataProviders = dataProviders;
        this.i18nResolver = i18nResolver;
    }

    @GET
    @ApiOperation(value="Get all unified connectivity backbone application links", response=RestExtendedApplicationLink.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="User does not have System Admin access")})
    public Response getApplicationLinks(@QueryParam(value="property") Set<String> propertyKeys, @QueryParam(value="data") Set<String> dataKeys) throws ServiceException {
        List<ApplicationLink> applicationLink = this.backboneApplinkService.getApplinks();
        Set<String> propertyKeySet = propertyKeys.isEmpty() ? DEFAULT_APPLINK_PROPERTY_KEYS : propertyKeys;
        ImmutableList.Builder restApplinks = ImmutableList.builder();
        for (ApplicationLink applink : applicationLink) {
            restApplinks.add((Object)new RestExtendedApplicationLink(applink, propertyKeySet, this.dataProviders.getData(applink, dataKeys)));
        }
        return RestUtil.ok(restApplinks.build());
    }

    @POST
    @ApiOperation(value="Creates or replaces existing unified connectivity backbone application link with a new one based on provided client credentials", response=RestExtendedApplicationLink.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="User does not have System Admin access")})
    public Response createOrReplaceApplicationLink(CreateBackboneApplicationLinkRequest backboneAppLinkRequest) throws ServiceException, TypeNotInstalledException {
        ApplicationLink applicationLink = this.backboneApplinkService.createOrReplaceApplink(backboneAppLinkRequest);
        return RestUtil.ok(new RestExtendedApplicationLink(applicationLink, Set.of(), this.dataProviders.getData(applicationLink, Set.of())));
    }

    @POST
    @Path(value="/disable")
    @ApiOperation(value="Disabled the backbone application link if it exists and disables connection in cloud to revoke existing credentials", response=DisableBackboneResponseDto.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=401, message="User does not have System Admin access"), @ApiResponse(code=408, message="Cannot delete connector: There are existing connections that depend on this connector")})
    public Response disableBackboneApplink() {
        boolean disabledInCloud;
        try {
            disabledInCloud = this.backboneApplinkService.disableBackboneConnection();
        }
        catch (CannotDisableBackboneException ex) {
            return RestResponses.error(Response.Status.CONFLICT, this.i18nResolver.getText("applinks.error.uniconn.backbone.delete.dependent.connections.error"));
        }
        return RestUtil.ok(new DisableBackboneResponseDto(disabledInCloud));
    }
}

