/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.internal.uniconn.BackboneConnectionHealthcheckResult;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.oauth2.client.api.lib.token.TokenServiceException;
import com.atlassian.oauth2.client.api.storage.token.exception.UnrecoverableTokenException;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class BackboneConnectionHealthcheckService {
    private static final Logger LOG = LoggerFactory.getLogger(BackboneConnectionHealthcheckService.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public BackboneConnectionHealthcheckResult checkConnectionHealthcheck(ApplicationLink applicationLink) {
        Object orgIdObject = applicationLink.getProperty(UniconnApplinkProperties.ORG_ID.key());
        Object linkIdObject = applicationLink.getProperty(UniconnApplinkProperties.LINK_ID.key());
        if (orgIdObject == null || linkIdObject == null) {
            LOG.warn("Missing orgId or linkId for backbone connection {}", (Object)applicationLink.getId());
            return BackboneConnectionHealthcheckResult.notAvailable();
        }
        String orgId = orgIdObject.toString();
        String linkId = linkIdObject.toString();
        if (orgId.trim().isEmpty() || linkId.trim().isEmpty()) {
            LOG.warn("Missing orgId or linkId for backbone connection {}", (Object)applicationLink.getId());
            return BackboneConnectionHealthcheckResult.notAvailable();
        }
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory(TwoLeggedOAuth2AuthenticationProvider.class);
        if (requestFactory == null) {
            return BackboneConnectionHealthcheckResult.notAvailable();
        }
        String healthcheckPath = String.format("/api/v3/orgs/%s/links/%s/healthcheck", orgId, linkId);
        return this.executeHealthcheckRequest(requestFactory, healthcheckPath, applicationLink.getId().toString());
    }

    private BackboneConnectionHealthcheckResult executeHealthcheckRequest(ApplicationLinkRequestFactory requestFactory, String healthcheckPath, String applicationLinkId) {
        try {
            return (BackboneConnectionHealthcheckResult)requestFactory.createRequest(Request.MethodType.GET, healthcheckPath).execute((ApplicationLinkResponseHandler)new HealthcheckResponseHandler());
        }
        catch (Exception e) {
            return this.handleRequestException(e, applicationLinkId);
        }
    }

    private BackboneConnectionHealthcheckResult handleRequestException(Exception e, String applicationLinkId) {
        if (e instanceof ResponseException) {
            LOG.error("Network failure during backbone connection healthcheck on application link {} : {}", (Object)applicationLinkId, (Object)e);
            return BackboneConnectionHealthcheckResult.networkFailure();
        }
        if (e instanceof CredentialsRequiredException) {
            LOG.error("Authentication failure during backbone connection healthcheck on application link {} : {}", (Object)applicationLinkId, (Object)e);
            return BackboneConnectionHealthcheckResult.authFailure();
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            if (cause instanceof UnrecoverableTokenException) {
                boolean isConnectException = BackboneConnectionHealthcheckService.isConnectExceptionNestedInTokenException((UnrecoverableTokenException)cause);
                LOG.error("Unrecoverable token error during backbone connection healthcheck on application link {} : {}", (Object)applicationLinkId, (Object)e.getMessage());
                return isConnectException ? BackboneConnectionHealthcheckResult.networkFailure() : BackboneConnectionHealthcheckResult.authFailure();
            }
            if (cause instanceof SocketException) {
                LOG.error("Connection error during backbone healthcheck on application link {} : {}", (Object)applicationLinkId, (Object)e.getMessage());
                return BackboneConnectionHealthcheckResult.networkFailure();
            }
        }
        LOG.error("Unknown error during backbone connection healthcheck", (Throwable)e);
        return BackboneConnectionHealthcheckResult.unknown();
    }

    private static boolean isConnectExceptionNestedInTokenException(UnrecoverableTokenException cause) {
        return cause.getCause() != null && cause.getCause() instanceof TokenServiceException && cause.getCause().getCause() != null && cause.getCause().getCause() instanceof SocketException;
    }

    private static class HealthcheckResponseHandler
    implements ApplicationLinkResponseHandler<BackboneConnectionHealthcheckResult> {
        private HealthcheckResponseHandler() {
        }

        public BackboneConnectionHealthcheckResult handle(Response response) {
            if (!response.isSuccessful()) {
                return this.mapErrorResponse(response);
            }
            try {
                JsonNode expiryNode;
                String responseBody = response.getResponseBodyAsString();
                JsonNode jsonNode = objectMapper.readTree(responseBody);
                Long tokenExpirationTime = null;
                JsonNode detailsNode = jsonNode.get("details");
                if (detailsNode != null && detailsNode.has("tokenExpirationTime") && (expiryNode = detailsNode.get("tokenExpirationTime")) != null && !expiryNode.isNull()) {
                    tokenExpirationTime = expiryNode.asLong();
                }
                return BackboneConnectionHealthcheckResult.healthy(tokenExpirationTime);
            }
            catch (IOException e) {
                LOG.warn("Failed to parse healthcheck response JSON", (Throwable)e);
                return BackboneConnectionHealthcheckResult.healthy(null);
            }
            catch (ResponseException e) {
                throw new RuntimeException(e);
            }
        }

        public BackboneConnectionHealthcheckResult credentialsRequired(Response response) {
            return BackboneConnectionHealthcheckResult.authFailure();
        }

        private BackboneConnectionHealthcheckResult mapErrorResponse(Response response) {
            return response.getStatusCode() == HttpStatus.UNAUTHORIZED.value() ? BackboneConnectionHealthcheckResult.authFailure() : BackboneConnectionHealthcheckResult.unknown();
        }
    }
}

