/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.internal.api.uniconn.BackboneApplicationType;
import com.atlassian.applinks.internal.rest.model.uniconn.CreateBackboneApplicationLinkRequest;
import com.atlassian.applinks.internal.rest.uniconn.exception.BackboneConnectionException;
import com.atlassian.applinks.internal.rest.uniconn.exception.CannotDisableBackboneException;
import com.atlassian.applinks.internal.uniconn.BackboneApplicationLinkService;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionService;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.UniconnOAuth2ClientService;
import com.atlassian.applinks.internal.uniconn.client.srs.SrsClient;
import com.atlassian.applinks.internal.uniconn.domain.BackboneConnection;
import com.atlassian.applinks.internal.uniconn.domain.BackboneConnectionRequest;
import com.atlassian.applinks.internal.uniconn.domain.BackboneConnectionStatus;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.OAuth2GrantType;
import com.atlassian.applinks.internal.uniconn.domain.OAuthClientDetails;
import com.atlassian.applinks.internal.uniconn.domain.SrsEncodedCredentials;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.sal.api.message.I18nResolver;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackboneConnectionService {
    private static final Logger LOG = LoggerFactory.getLogger(BackboneConnectionService.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final MutatingApplicationLinkService applicationLinkService;
    private final TypeAccessor typeAccessor;
    private final BackboneApplicationLinkService backboneApplicationLinkService;
    private final UniconnOAuth2ClientService uniconnOAuth2ClientService;
    private final CloudProductConnectionService cloudProductConnectionService;
    private final SrsClient srsClient;
    private final I18nResolver i18nResolver;

    @Autowired
    public BackboneConnectionService(MutatingApplicationLinkService applicationLinkService, TypeAccessor typeAccessor, BackboneApplicationLinkService backboneApplicationLinkService, UniconnOAuth2ClientService uniconnOAuth2ClientService, CloudProductConnectionService cloudProductConnectionService, SrsClient srsClient, I18nResolver i18nResolver) {
        this.applicationLinkService = applicationLinkService;
        this.typeAccessor = typeAccessor;
        this.backboneApplicationLinkService = backboneApplicationLinkService;
        this.uniconnOAuth2ClientService = uniconnOAuth2ClientService;
        this.cloudProductConnectionService = cloudProductConnectionService;
        this.srsClient = srsClient;
        this.i18nResolver = i18nResolver;
    }

    public List<ApplicationLink> getApplinks() {
        ApplicationLink backboneApplink = this.applicationLinkService.getPrimaryApplicationLink(BackboneApplicationType.class);
        return backboneApplink == null ? Collections.emptyList() : Collections.singletonList(backboneApplink);
    }

    private ApplicationLink getPrimaryBackboneApplink() {
        return this.applicationLinkService.getPrimaryApplicationLink(BackboneApplicationType.class);
    }

    public boolean disableBackboneConnection() throws CannotDisableBackboneException {
        ApplicationLink backboneApplink = this.getPrimaryBackboneApplink();
        if (backboneApplink != null) {
            List<CloudProductConnection> connections = this.cloudProductConnectionService.getAllConnections();
            if (!connections.isEmpty()) {
                throw new CannotDisableBackboneException();
            }
            boolean isDisabledInCloud = this.disableLinkInSrs();
            this.disableBackboneApplicationLink(backboneApplink);
            return isDisabledInCloud;
        }
        return false;
    }

    private void disableBackboneApplicationLink(ApplicationLink backboneApplink) {
        this.uniconnOAuth2ClientService.deleteOutboundClient(backboneApplink.getClientCredentialsClientConfigurationId());
        this.updateBackboneConnectionStatus(backboneApplink, BackboneConnectionStatus.DISCONNECTED);
    }

    private boolean disableLinkInSrs() {
        try {
            this.srsClient.disableBackboneConnection();
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to disable backbone connection in SRS", (Throwable)e);
            return false;
        }
    }

    public ApplicationLink createOrReplaceApplink(CreateBackboneApplicationLinkRequest backboneAppLinkRequest) throws TypeNotInstalledException {
        BackboneConnection backboneConnection;
        try {
            backboneConnection = this.buildBackboneConnection(this.decodeClientCredentials(backboneAppLinkRequest.clientCredentials()));
        }
        catch (Exception e) {
            LOG.error("Error building backbone connection from client credentials", (Throwable)e);
            throw new BackboneConnectionException(this.i18nResolver.getText("applinks.error.uniconn.backbone.credentials.invalid"), e);
        }
        this.handleExistingBackboneApplicationLink(backboneConnection);
        ClientConfigurationEntity clientCredentials = null;
        ApplicationLink backboneApplink = null;
        try {
            clientCredentials = this.uniconnOAuth2ClientService.createOrUpdateOutgoingClient(null, backboneConnection.orgName(), backboneConnection.orgId(), backboneConnection.oauthClientDetails());
            BackboneConnectionRequest request = new BackboneConnectionRequest(backboneConnection, clientCredentials.getId());
            backboneApplink = this.backboneApplicationLinkService.createApplicationLink(request);
        }
        catch (Exception e) {
            LOG.error("Error creating or replacing backbone application link", (Throwable)e);
            this.backboneApplicationLinkService.cleanupFailedCreation(backboneApplink, null, null, clientCredentials != null ? clientCredentials.getId() : null);
            throw new BackboneConnectionException(this.i18nResolver.getText("applinks.error.uniconn.backbone.create.error"), e);
        }
        return backboneApplink;
    }

    public void updateBackboneConnectionStatus(ApplicationLink backboneApplink, BackboneConnectionStatus status) {
        backboneApplink.putProperty(UniconnApplinkProperties.CONNECTION_STATUS.key(), (Object)status.name());
    }

    private void handleExistingBackboneApplicationLink(BackboneConnection backboneConnection) throws TypeNotInstalledException {
        ApplicationId applicationId = backboneConnection.applicationId();
        MutableApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(applicationId);
        if (applicationLink != null && !(applicationLink.getType() instanceof BackboneApplicationType)) {
            throw new IllegalStateException("Application with server ID " + String.valueOf(applicationId) + " already exists");
        }
        ApplicationLink existingBackboneApplink = this.getPrimaryBackboneApplink();
        if (existingBackboneApplink != null) {
            this.applicationLinkService.deleteApplicationLink(existingBackboneApplink);
        }
    }

    private BackboneConnection buildBackboneConnection(SrsEncodedCredentials backboneConnectionDetails) {
        String displayUrl = UniconnApplinkUtils.getDisplayUrl(backboneConnectionDetails.orgId());
        ApplicationId applicationId = ApplicationIdUtil.generate((URI)URI.create(displayUrl));
        ApplicationType backboneType = this.typeAccessor.getApplicationType(BackboneApplicationType.class);
        return new BackboneConnection(Objects.requireNonNull(applicationId, "applicationId"), Objects.requireNonNull(backboneType, "applicationType"), Objects.requireNonNull(backboneConnectionDetails.linkId(), "linkId"), Objects.requireNonNull(backboneConnectionDetails.orgId(), "orgId"), Objects.requireNonNull(backboneConnectionDetails.orgName(), "orgName"), backboneConnectionDetails.name(), BackboneConnectionStatus.CREATED, UniconnApplinkUtils.getBackboneRpcUrl(), Objects.requireNonNull(displayUrl, "displayUrl"), backboneConnectionDetails.oAuth2Credentials().clientExpiryMillis(), new OAuthClientDetails(OAuth2GrantType.CLIENT_CREDENTIALS_GRANT, Objects.requireNonNull(backboneConnectionDetails.oAuth2Credentials().clientId(), "clientId"), Objects.requireNonNull(backboneConnectionDetails.oAuth2Credentials().clientSecret(), "clientSecret"), backboneConnectionDetails.oAuth2Credentials().scopes(), Objects.requireNonNull(backboneConnectionDetails.oAuth2Credentials().tokenEndpoint(), "tokenEndpoint"), null, Collections.emptyMap()));
    }

    private SrsEncodedCredentials decodeClientCredentials(String clientCredentials) throws JsonProcessingException {
        Objects.requireNonNull(clientCredentials, "Client credentials must not be null");
        if (clientCredentials.trim().isEmpty()) {
            throw new IllegalArgumentException("Client credentials must not be empty");
        }
        String sanitizedToken = clientCredentials.trim();
        String base64decoded = new String(Base64.getDecoder().decode(sanitizedToken));
        SrsEncodedCredentials srsEncodedCredentials = (SrsEncodedCredentials)OBJECT_MAPPER.readValue(base64decoded, SrsEncodedCredentials.class);
        return srsEncodedCredentials;
    }
}

