/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.core.DefaultApplicationLinkService;
import com.atlassian.applinks.internal.api.uniconn.BackboneApplicationType;
import com.atlassian.applinks.internal.uniconn.client.srs.SrsClient;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsCloudProductConnectionMetadataRequestMapper;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.sal.api.net.ResponseException;
import java.util.List;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SrsMetadataPublisherService {
    private static final Logger LOG = LoggerFactory.getLogger(SrsMetadataPublisherService.class);
    private final DefaultApplicationLinkService applicationLinkService;
    private final SrsClient srsClient;
    private final SrsCloudProductConnectionMetadataRequestMapper srsCloudProductConnectionMetadataRequestMapper;

    @Autowired
    public SrsMetadataPublisherService(DefaultApplicationLinkService applicationLinkService, SrsClient srsClient, SrsCloudProductConnectionMetadataRequestMapper srsCloudProductConnectionMetadataRequestMapper) {
        this.applicationLinkService = applicationLinkService;
        this.srsClient = srsClient;
        this.srsCloudProductConnectionMetadataRequestMapper = srsCloudProductConnectionMetadataRequestMapper;
    }

    public void publishDCMetadata() throws ResponseException {
        LOG.debug("Fetching application links for metadata publishing.");
        List<ApplicationLink> uniconnAppLinks = StreamSupport.stream(this.applicationLinkService.getApplicationLinks().spliterator(), false).filter(UniconnApplinkUtils::isUniconnApplink).filter(link -> !(link.getType() instanceof BackboneApplicationType)).toList();
        LOG.debug("Found {} application links for metadata publishing.", (Object)uniconnAppLinks.size());
        this.srsClient.sendDcMetadata(this.srsCloudProductConnectionMetadataRequestMapper.toDto(uniconnAppLinks));
    }
}

