/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.internal.feature.ApplinksFeatureService;
import com.atlassian.applinks.internal.feature.ApplinksFeatures;
import com.atlassian.applinks.internal.uniconn.SrsMetadataPublisherService;
import com.atlassian.applinks.internal.uniconn.UniconnConnectionLifecycleService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UniconnConnectionLifecycleJob
implements JobRunner,
LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(UniconnConnectionLifecycleJob.class);
    private static final String SCHEDULE_INTERVAL_SYS_PROP = "applinks.uniconn.lifecycle.interval.seconds";
    private static final long DEFAULT_SCHEDULE_INTERVAL_SECONDS = TimeUnit.MINUTES.toSeconds(15L);
    private static final long MIN_SCHEDULE_INTERVAL_SECONDS = TimeUnit.MINUTES.toSeconds(1L);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)UniconnConnectionLifecycleJob.class.getName());
    private static final JobId JOB_ID = JobId.of((String)"uniconn-connection-lifecycle-job");
    private final UniconnConnectionLifecycleService uniconnConnectionLifecycleService;
    private final SrsMetadataPublisherService srsMetadataPublisherService;
    private final ApplinksFeatureService featureService;
    @Nonnull
    private final SchedulerService scheduler;

    @Autowired
    public UniconnConnectionLifecycleJob(UniconnConnectionLifecycleService uniconnConnectionLifecycleService, SrsMetadataPublisherService srsMetadataPublisherService, ApplinksFeatureService featureService, @Nonnull SchedulerService scheduler) {
        this.uniconnConnectionLifecycleService = uniconnConnectionLifecycleService;
        this.srsMetadataPublisherService = srsMetadataPublisherService;
        this.featureService = featureService;
        this.scheduler = Objects.requireNonNull(scheduler);
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        if (!this.featureService.isEnabledForAllUsers(ApplinksFeatures.UNICONN)) {
            log.debug("Uniconn feature is disabled. Skipping Uniconn connection lifecycle job.");
            return JobRunnerResponse.success();
        }
        try {
            this.uniconnConnectionLifecycleService.rotateAndDeleteCloudProductConnectionApplicationLinks();
            this.srsMetadataPublisherService.publishDCMetadata();
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    private Schedule getSchedule() {
        long interval = UniconnConnectionLifecycleJob.parseScheduleIntervalMillis();
        return Schedule.forInterval((long)interval, null);
    }

    private static long parseScheduleIntervalMillis() {
        long intervalMillis = TimeUnit.SECONDS.toMillis(DEFAULT_SCHEDULE_INTERVAL_SECONDS);
        String rawValue = System.getProperty(SCHEDULE_INTERVAL_SYS_PROP);
        if (!StringUtils.isBlank((CharSequence)rawValue)) {
            try {
                long parsedSeconds = Long.parseLong(rawValue);
                intervalMillis = TimeUnit.SECONDS.toMillis(Math.max(parsedSeconds, MIN_SCHEDULE_INTERVAL_SECONDS));
            }
            catch (NumberFormatException e) {
                log.warn("Invalid value for system property '{}': '{}'. Using default: {}", new Object[]{SCHEDULE_INTERVAL_SYS_PROP, rawValue, TimeUnit.SECONDS.toMillis(DEFAULT_SCHEDULE_INTERVAL_SECONDS)});
            }
        }
        return intervalMillis;
    }

    public void onStart() {
        this.scheduler.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        try {
            this.scheduler.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withSchedule(this.getSchedule()));
        }
        catch (SchedulerServiceException e) {
            log.error("Unable to schedule uniconn connection lifecycle job", (Throwable)e);
        }
    }

    public void onStop() {
        this.scheduler.unregisterJobRunner(JOB_RUNNER_KEY);
    }
}

