/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.core.DefaultApplicationLinkService;
import com.atlassian.applinks.core.link.InternalApplicationLink;
import com.atlassian.applinks.core.property.ApplicationLinkProperties;
import com.atlassian.applinks.core.property.PropertyService;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionApplicationLinkService;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionService;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionStatus;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.oauth2.provider.api.client.internal.InternalRotationClientService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UniconnConnectionLifecycleService {
    private static final Logger LOG = LoggerFactory.getLogger(UniconnConnectionLifecycleService.class);
    private final DefaultApplicationLinkService applicationLinkService;
    private final CloudProductConnectionService cloudProductConnectionService;
    private final CloudProductConnectionApplicationLinkService cloudProductConnectionApplicationLinkService;
    private final InternalRotationClientService internalClientService;
    private final PropertyService propertyService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public UniconnConnectionLifecycleService(DefaultApplicationLinkService applicationLinkService, CloudProductConnectionService cloudProductConnectionService, CloudProductConnectionApplicationLinkService cloudProductConnectionApplicationLinkService, InternalRotationClientService internalClientService, PropertyService propertyService, TransactionTemplate transactionTemplate) {
        this.applicationLinkService = applicationLinkService;
        this.cloudProductConnectionService = cloudProductConnectionService;
        this.cloudProductConnectionApplicationLinkService = cloudProductConnectionApplicationLinkService;
        this.internalClientService = internalClientService;
        this.propertyService = propertyService;
        this.transactionTemplate = transactionTemplate;
    }

    public void rotateAndDeleteCloudProductConnectionApplicationLinks() {
        long startNanos = System.nanoTime();
        Instant startTime = Instant.now();
        LOG.debug("Fetching cloud product connections from SRS");
        List<CloudProductConnection> cloudProductConnections = this.cloudProductConnectionService.getAllConnections();
        LOG.debug("Found {} uniconn product connections from SRS", (Object)cloudProductConnections.size());
        LOG.info("LifeCycleJob started at {} : SRS connections fetched: {}", (Object)startTime, (Object)cloudProductConnections.size());
        ArrayList<String> deletedLocalApplinksConnectionIds = new ArrayList<String>();
        ArrayList<String> deletedSrsConnectionIds = new ArrayList<String>();
        ArrayList<String> rotatedConnectionIds = new ArrayList<String>();
        for (CloudProductConnection connection : cloudProductConnections) {
            try {
                if (connection.status() == CloudProductConnectionStatus.DELETED) {
                    if (!this.tryDeleteApplinkForDeletedConnection(connection)) continue;
                    deletedLocalApplinksConnectionIds.add(connection.id());
                    continue;
                }
                if (this.isCloudOrphanConnection(connection)) {
                    if (!this.tryDeleteCloudOrphanConnection(connection)) continue;
                    deletedSrsConnectionIds.add(connection.id());
                    continue;
                }
                if (!UniconnApplinkUtils.shouldRotateCredentials(connection) || !this.tryRotateCredentials(connection)) continue;
                rotatedConnectionIds.add(connection.id());
            }
            catch (Exception e) {
                LOG.error("Unexpected error processing connection with id: {}", (Object)connection.id(), (Object)e);
            }
        }
        long endNanos = System.nanoTime();
        Instant endTime = Instant.now();
        long totalTimeMs = TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos);
        LOG.info("LifeCycleJob ended at {}: Deleted local applinks for connections: {}, Deleted SRS connections:{}, Rotation performed for connections: {}, Total time taken: {}ms", new Object[]{endTime, deletedLocalApplinksConnectionIds, deletedSrsConnectionIds, rotatedConnectionIds, totalTimeMs});
    }

    private void deleteAppLinkWithInternalClientService(ApplicationLink appLink) {
        this.transactionTemplate.execute(() -> {
            String clientId = appLink.getClientId();
            if (clientId != null) {
                this.internalClientService.removeById(clientId);
                ApplicationLinkProperties properties = this.propertyService.getApplicationLinkProperties(appLink.getId());
                properties.setClientId(null);
            }
            this.cloudProductConnectionApplicationLinkService.deleteApplinkLocally(UniconnApplinkUtils.getCloudProductConnectionId(appLink));
            return null;
        });
    }

    private boolean isCloudOrphanConnection(CloudProductConnection connection) {
        return connection.status() == CloudProductConnectionStatus.CONNECTED && this.cloudProductConnectionApplicationLinkService.findApplicationLinkByConnectionId(connection.id()) == null;
    }

    private boolean tryDeleteCloudOrphanConnection(CloudProductConnection connection) {
        try {
            this.cloudProductConnectionApplicationLinkService.deleteCloudConnection(connection.id());
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to delete cloud orphan connection with id: {}", (Object)connection.id(), (Object)e);
            return false;
        }
    }

    private boolean tryDeleteApplinkForDeletedConnection(CloudProductConnection connection) {
        LOG.debug("Attempting to delete uniconn applink for deleted connection with id: {}", (Object)connection.id());
        try {
            InternalApplicationLink appLinkToDelete = this.applicationLinkService.getApplicationLink(new ApplicationId(connection.applicationId()));
            if (appLinkToDelete == null) {
                LOG.debug("No applink found for deleted connection with id: {}", (Object)connection.id());
                return false;
            }
            String cloudProductConnectionId = UniconnApplinkUtils.getCloudProductConnectionId((ApplicationLink)appLinkToDelete);
            if (UniconnApplinkUtils.isUniconnApplink((ApplicationLink)appLinkToDelete) && cloudProductConnectionId != null && cloudProductConnectionId.equals(connection.id())) {
                LOG.info("Deleting uniconn applink with id: {}", (Object)appLinkToDelete.getId());
                this.deleteAppLinkWithInternalClientService((ApplicationLink)appLinkToDelete);
                return true;
            }
        }
        catch (TypeNotInstalledException e) {
            LOG.debug("No applink found for deleted connection with id: {}", (Object)connection.id());
        }
        return false;
    }

    private boolean tryRotateCredentials(CloudProductConnection connection) {
        try {
            LOG.info("Rotating credentials for connection with id: {}", (Object)connection.id());
            this.cloudProductConnectionApplicationLinkService.rotateCloudProductConnectionApplicationLinkCredentials(connection);
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to rotate credentials for connection with id: {}", (Object)connection.id(), (Object)e);
            return false;
        }
    }
}

