/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.uniconn.UniconnValidationService;
import com.atlassian.applinks.internal.uniconn.domain.OAuth2GrantType;
import com.atlassian.applinks.internal.uniconn.domain.OAuthClientDetails;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigStorageService;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.client.api.storage.config.ProviderType;
import com.atlassian.oauth2.client.api.storage.token.exception.ConfigurationNotFoundException;
import com.atlassian.oauth2.provider.api.client.ClientService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UniconnOAuth2ClientService {
    private static final Logger LOG = LoggerFactory.getLogger(UniconnOAuth2ClientService.class);
    private final ClientConfigStorageService clientConfigStorageService;
    private final UniconnValidationService validationService;
    private final ClientService oauthClientService;

    @Autowired
    public UniconnOAuth2ClientService(ClientConfigStorageService clientConfigStorageService, UniconnValidationService validationService, ClientService oauthClientService) {
        this.clientConfigStorageService = clientConfigStorageService;
        this.validationService = validationService;
        this.oauthClientService = oauthClientService;
    }

    @Nonnull
    public ClientConfigurationEntity createOrUpdateOutgoingClient(@Nullable String existingClientId, String connectionName, String connectionId, OAuthClientDetails clientDetails) throws ServiceException, ConfigurationNotFoundException {
        this.validateClientDetails(clientDetails);
        String name = String.format("UC %s-%s (%s)", connectionName, connectionId, clientDetails.grantType().name().toLowerCase());
        GrantType grantType = switch (clientDetails.grantType()) {
            default -> throw new MatchException(null, null);
            case OAuth2GrantType.AUTHORIZATION_CODE_GRANT -> GrantType.AUTHORIZATION_CODE_GRANT;
            case OAuth2GrantType.CLIENT_CREDENTIALS_GRANT -> GrantType.CLIENT_CREDENTIALS_GRANT;
        };
        ClientConfigurationEntity.Builder clientConfigBuilder = ClientConfigurationEntity.builder().id(existingClientId).name(name).grantType(grantType).providerType(ProviderType.GENERIC).clientId(clientDetails.clientId()).clientSecret(clientDetails.clientSecret()).tokenEndpoint(clientDetails.tokenEndpoint()).scopes(new ArrayList<String>(clientDetails.scopes())).customParams(clientDetails.customParams()).authorizationEndpoint(clientDetails.authorizationEndpoint() != null ? clientDetails.authorizationEndpoint() : "");
        return this.clientConfigStorageService.save(clientConfigBuilder.build());
    }

    public void deleteOutboundClient(@Nullable String clientId) {
        if (clientId != null) {
            try {
                this.clientConfigStorageService.delete(clientId);
            }
            catch (ConfigurationNotFoundException ex) {
                LOG.error("Outgoing configuration not found with id  : {}", (Object)clientId);
            }
        }
    }

    public void deleteInboundClient(@Nullable String clientId) {
        if (clientId != null) {
            try {
                this.oauthClientService.removeById(clientId);
            }
            catch (Exception ex) {
                LOG.error("Failed to delete incoming client during clean up", (Throwable)ex);
            }
        }
    }

    private void validateClientDetails(OAuthClientDetails clientDetails) throws ServiceException {
        this.validationService.validateStringNotBlank(clientDetails.clientId(), "clientId");
        this.validationService.validateStringNotBlank(clientDetails.clientSecret(), "clientSecret");
        this.validationService.validateStringMaxLength(clientDetails.clientId(), "clientId");
        this.validationService.validateStringMaxLength(clientDetails.clientSecret(), "clientSecret");
        this.validationService.validateScopes(clientDetails.scopes());
        this.validationService.validateUri(clientDetails.tokenEndpoint(), "tokenEndpoint");
        if (clientDetails.grantType() == OAuth2GrantType.AUTHORIZATION_CODE_GRANT) {
            this.validationService.validateUri(clientDetails.authorizationEndpoint(), "authorizationEndpoint");
        }
    }
}

