/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionCredentialsExpiryResolver;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionConsent;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionConsentAccessEntitlements;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionRequestStatus;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionStatus;
import com.atlassian.applinks.internal.uniconn.domain.Experience;
import com.atlassian.applinks.internal.uniconn.domain.MergedCloudProductConnectionSource;
import com.atlassian.applinks.internal.uniconn.domain.UniconnProductConnection;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UniconnProductConnectionRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(UniconnProductConnectionRetriever.class);
    private final CloudProductConnectionCredentialsExpiryResolver credentialsExpiryResolver;
    private final I18nResolver i18nResolver;

    @Autowired
    public UniconnProductConnectionRetriever(CloudProductConnectionCredentialsExpiryResolver credentialsExpiryResolver, I18nResolver i18nResolver) {
        this.credentialsExpiryResolver = credentialsExpiryResolver;
        this.i18nResolver = i18nResolver;
    }

    public List<UniconnProductConnection> getUniconnProductConnections(@Nonnull List<ApplicationLink> applinks, @Nonnull List<CloudProductConnection> cloudProductConnections, ApplicationLink backboneApplink) {
        UniconnProductConnection piExperienceConnection = this.createPiExperienceFromBackboneApplinks(backboneApplink);
        if (piExperienceConnection != null) {
            return List.of(piExperienceConnection);
        }
        HashMap<String, CloudProductConnection> connectedConnections = new HashMap<String, CloudProductConnection>();
        HashMap<String, CloudProductConnection> createdConnections = new HashMap<String, CloudProductConnection>();
        for (CloudProductConnection connection : cloudProductConnections) {
            if (connection.status() == CloudProductConnectionStatus.CREATED) {
                createdConnections.put(connection.id(), connection);
                continue;
            }
            connectedConnections.put(connection.id(), connection);
        }
        List<UniconnProductConnection> enrichedConnections = this.enrichApplinksWithCloudProductConnection(applinks, connectedConnections, createdConnections);
        List<UniconnProductConnection> createdConnectionRequests = this.getCloudProductConnectionRequests(createdConnections);
        ArrayList<UniconnProductConnection> productConnections = new ArrayList<UniconnProductConnection>(enrichedConnections);
        productConnections.addAll(createdConnectionRequests);
        LOG.debug("Returning {} product connections from {} applinks with {} connections, ", new Object[]{productConnections.size(), applinks.size(), cloudProductConnections.size()});
        return productConnections;
    }

    private List<UniconnProductConnection> enrichApplinksWithCloudProductConnection(@Nonnull List<ApplicationLink> applinks, @Nonnull Map<String, CloudProductConnection> connectedConnections, Map<String, CloudProductConnection> createdConnections) {
        ArrayList<UniconnProductConnection> enrichedConnections = new ArrayList<UniconnProductConnection>();
        for (ApplicationLink applink : applinks) {
            String connectionId = UniconnApplinkUtils.getCloudProductConnectionId(applink);
            if (connectionId == null || createdConnections.containsKey(connectionId)) continue;
            CloudProductConnection connection = connectedConnections.get(connectionId);
            UniconnProductConnection merged = this.createCloudProductConnectionWithApplink(applink, connection, connectionId);
            enrichedConnections.add(merged);
        }
        LOG.debug("Phase 1: Enriched {} applinks with cloud product connection data", (Object)enrichedConnections.size());
        return enrichedConnections;
    }

    private List<UniconnProductConnection> getCloudProductConnectionRequests(@Nonnull Map<String, CloudProductConnection> createdConnections) {
        ArrayList<UniconnProductConnection> connectionRequests = new ArrayList<UniconnProductConnection>();
        for (CloudProductConnection connection : createdConnections.values()) {
            UniconnProductConnection cloudOnly = this.createProductConnectionFromCloudRequestOnly(connection);
            connectionRequests.add(cloudOnly);
        }
        LOG.debug("Phase 2: Added {} cloud product connection requests without local applinks", (Object)connectionRequests.size());
        return connectionRequests;
    }

    private UniconnProductConnection createCloudProductConnectionWithApplink(ApplicationLink applink, @Nullable CloudProductConnection connection, String connectionId) {
        if (connection != null) {
            return this.createEnrichedProductConnectionFromApplinkAndCloudConnection(applink, connection);
        }
        return this.createProductConnectionFromApplinkOnly(applink, connectionId);
    }

    private UniconnProductConnection createEnrichedProductConnectionFromApplinkAndCloudConnection(ApplicationLink applink, CloudProductConnection connection) {
        Long finalExpiry = UniconnApplinkUtils.areCredentialsRevoked(applink) ? null : (Long)this.credentialsExpiryResolver.getProductConnectionExpiry(applink, connection).orElse(null);
        return new UniconnProductConnection(connection.id(), connection.name(), connection.description(), connection.cloudContainerName(), CloudProductConnectionRequestStatus.ACCEPTED, connection.iconId(), connection.iconImageOverride(), connection.displayUrl(), finalExpiry, connection.connectionDependencies(), connection.experience(), connection.deleteConfirmationMessageOverride(), this.extractConsentFromApplink(applink), MergedCloudProductConnectionSource.ENRICHED);
    }

    private UniconnProductConnection createProductConnectionFromApplinkOnly(ApplicationLink applink, String connectionId) {
        Object nameProperty = applink.getProperty(UniconnApplinkProperties.CLOUD_PRODUCT_NAME.key());
        Object containerNameProperty = applink.getProperty(UniconnApplinkProperties.CLOUD_PRODUCT_CONTAINER_NAME.key());
        Object iconIdProperty = applink.getProperty(UniconnApplinkProperties.CLOUD_PRODUCT_ICON_ID.key());
        String name = nameProperty != null ? nameProperty.toString() : null;
        String containerName = containerNameProperty != null ? containerNameProperty.toString() : null;
        String iconId = iconIdProperty != null ? iconIdProperty.toString() : null;
        Long clientExpiry = UniconnApplinkUtils.areCredentialsRevoked(applink) ? null : (Long)this.credentialsExpiryResolver.getClientExpiry(applink.getClientId()).orElse(null);
        return new UniconnProductConnection(connectionId, name != null ? name : applink.getName(), null, containerName, CloudProductConnectionRequestStatus.ACCEPTED, iconId, null, applink.getDisplayUrl().toString(), clientExpiry, null, null, null, this.extractConsentFromApplink(applink), MergedCloudProductConnectionSource.APPLINK);
    }

    private UniconnProductConnection createProductConnectionFromCloudRequestOnly(CloudProductConnection connection) {
        return new UniconnProductConnection(connection.id(), connection.name(), connection.description(), connection.cloudContainerName(), CloudProductConnectionRequestStatus.PENDING, connection.iconId(), connection.iconImageOverride(), connection.displayUrl(), null, connection.connectionDependencies(), connection.experience(), connection.deleteConfirmationMessageOverride(), null, MergedCloudProductConnectionSource.CLOUD);
    }

    @Nullable
    private CloudProductConnectionConsent extractConsentFromApplink(ApplicationLink applink) {
        Object scopesProperty = applink.getProperty(UniconnApplinkProperties.INCOMING_SCOPES.key());
        Object entitlementsProperty = applink.getProperty(UniconnApplinkProperties.DATA_EXPORT_ENTITLEMENTS.key());
        if (scopesProperty == null && entitlementsProperty == null) {
            return null;
        }
        Set<String> scopes = this.extractSetFromProperty(scopesProperty);
        Set<String> dataExportEntitlements = this.extractSetFromProperty(entitlementsProperty);
        CloudProductConnectionConsentAccessEntitlements dcAccessEntitlements = new CloudProductConnectionConsentAccessEntitlements(scopes, dataExportEntitlements);
        return new CloudProductConnectionConsent(dcAccessEntitlements);
    }

    private Set<String> extractSetFromProperty(@Nullable Object property) {
        if (property == null) {
            return Set.of();
        }
        if (property instanceof List) {
            List list = (List)property;
            return list.stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toSet());
        }
        if (property instanceof Set) {
            Set set = (Set)property;
            return set.stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toSet());
        }
        LOG.warn("Unexpected property type for consent extraction: {}", property.getClass());
        return Set.of();
    }

    private UniconnProductConnection createPiExperienceFromBackboneApplinks(ApplicationLink backboneApplink) {
        if (backboneApplink == null) {
            return null;
        }
        UniconnProductConnection piExperience = null;
        if (StringUtils.isBlank((CharSequence)backboneApplink.getClientCredentialsClientConfigurationId())) {
            piExperience = this.createPiExperienceFromBackboneApplink(backboneApplink);
        }
        return piExperience;
    }

    private UniconnProductConnection createPiExperienceFromBackboneApplink(ApplicationLink backboneApplink) {
        String backboneId = backboneApplink.getId().get();
        String connectionId = "synthetic-pi-experience-" + backboneId;
        String name = this.i18nResolver.getText("applinks-atlassian-uniconn-ui.portfolio-insights.name");
        Object orgNameProperty = backboneApplink.getProperty("orgName");
        String cloudContainerName = orgNameProperty != null ? orgNameProperty.toString() : null;
        String iconId = "AtlassianIcon";
        String displayUrl = backboneApplink.getDisplayUrl() != null ? backboneApplink.getDisplayUrl().toString() : "";
        Long credentialsExpiry = this.credentialsExpiryResolver.getClientExpiry(backboneApplink.getClientId()).orElse(null);
        return new UniconnProductConnection(connectionId, name, null, cloudContainerName, CloudProductConnectionRequestStatus.ACCEPTED, "AtlassianIcon", null, displayUrl, credentialsExpiry, null, new Experience(this.i18nResolver.getText("applinks-atlassian-uniconn-ui.portfolio-insights.experience.name"), null, Set.of("write:portfolio-insights:assessment")), null, null, MergedCloudProductConnectionSource.LEGACY);
    }
}

