/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.client.srs.mapper;

import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.internal.api.uniconn.CloudProductApplicationType;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsCloudProductConnectionResponse;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsCredentialRotation;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsCloudProductConnectionStatusMapper;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsCloudSubProductMapper;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsExperienceMapper;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.CredentialRotation;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.util.TypeAccessor;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SrsCloudProductConnectionResponseMapper {
    private static final Logger LOG = LoggerFactory.getLogger(SrsCloudProductConnectionResponseMapper.class);
    private final SrsExperienceMapper experienceMapper;
    private final SrsCloudSubProductMapper subProductMapper;
    private final TypeAccessor typeAccessor;

    @Autowired
    public SrsCloudProductConnectionResponseMapper(SrsExperienceMapper experienceMapper, SrsCloudSubProductMapper subProductMapper, TypeAccessor typeAccessor) {
        this.experienceMapper = experienceMapper;
        this.subProductMapper = subProductMapper;
        this.typeAccessor = typeAccessor;
    }

    public Optional<CloudProductConnection> fromDto(@Nonnull SrsCloudProductConnectionResponse srsCloudProductConnectionResponse) {
        TypeId applicationTypeId = new TypeId(srsCloudProductConnectionResponse.applicationTypeId());
        ApplicationType applicationType = this.typeAccessor.loadApplicationType(applicationTypeId);
        if (applicationType == null) {
            LOG.debug("Mapping connection {} with CloudProductApplicationType with product type {}", (Object)srsCloudProductConnectionResponse.id(), (Object)srsCloudProductConnectionResponse.applicationTypeId());
            applicationType = this.typeAccessor.getApplicationType(CloudProductApplicationType.class);
        }
        CredentialRotation credentialRotation = srsCloudProductConnectionResponse.credentialRotation() != null ? this.mapCredentialRotation(srsCloudProductConnectionResponse.credentialRotation()) : null;
        return Optional.of(new CloudProductConnection(srsCloudProductConnectionResponse.id(), srsCloudProductConnectionResponse.linkId(), srsCloudProductConnectionResponse.name(), SrsCloudProductConnectionStatusMapper.map(srsCloudProductConnectionResponse.status()), srsCloudProductConnectionResponse.applicationId(), srsCloudProductConnectionResponse.applicationTypeId(), applicationType, srsCloudProductConnectionResponse.cloudContainerName(), srsCloudProductConnectionResponse.rpcUrl(), srsCloudProductConnectionResponse.displayUrl(), srsCloudProductConnectionResponse.dcAuthCodeRedirectUrls(), this.experienceMapper.fromDto(srsCloudProductConnectionResponse.experience()), List.of(), srsCloudProductConnectionResponse.cloudCredentialsExpiry(), srsCloudProductConnectionResponse.connectionDependencies(), srsCloudProductConnectionResponse.iconId(), srsCloudProductConnectionResponse.iconImageOverride(), srsCloudProductConnectionResponse.description(), srsCloudProductConnectionResponse.deleteConfirmationMessageOverride(), srsCloudProductConnectionResponse.heartbeatPath(), credentialRotation));
    }

    private CredentialRotation mapCredentialRotation(SrsCredentialRotation srsCredentialRotation) {
        return new CredentialRotation(srsCredentialRotation.status(), srsCredentialRotation.id());
    }
}

