/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.client.srs.mapper;

import com.atlassian.applinks.internal.uniconn.CloudProductConnectionCredentialsExpiryResolver;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsExchangeOauthCredentialsRequest;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsOauthClientRequest;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsOauthCredentialsRequestMapper;
import com.atlassian.oauth2.provider.api.client.Client;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SrsExchangeOauthCredentialsRequestMapper {
    private final SrsOauthCredentialsRequestMapper srsOauthCredentialsRequestMapper;
    private final CloudProductConnectionCredentialsExpiryResolver credentialsExpiryResolver;

    public SrsExchangeOauthCredentialsRequestMapper(SrsOauthCredentialsRequestMapper srsOauthCredentialsRequestMapper, CloudProductConnectionCredentialsExpiryResolver credentialsExpiryResolver) {
        this.srsOauthCredentialsRequestMapper = srsOauthCredentialsRequestMapper;
        this.credentialsExpiryResolver = credentialsExpiryResolver;
    }

    public SrsExchangeOauthCredentialsRequest toDto(@Nullable Client client, @Nullable String rotationId) {
        if (client == null) {
            return new SrsExchangeOauthCredentialsRequest(rotationId, null);
        }
        Long expiry = this.credentialsExpiryResolver.getClientExpiry(client.getId()).orElse(null);
        Set<String> scopes = Arrays.stream(client.getScope().toString().split(" ")).collect(Collectors.toSet());
        SrsOauthClientRequest clientRequest = new SrsOauthClientRequest(this.srsOauthCredentialsRequestMapper.toDto(client), scopes, expiry);
        return new SrsExchangeOauthCredentialsRequest(rotationId, clientRequest);
    }
}

