/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.client.srs.mapper;

import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsAccessEntitlementDetail;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsAccessEntitlements;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsExperienceResponse;
import com.atlassian.applinks.internal.uniconn.domain.DcAccessEntitlementDetail;
import com.atlassian.applinks.internal.uniconn.domain.DcAccessEntitlements;
import com.atlassian.applinks.internal.uniconn.domain.Experience;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class SrsExperienceMapper {
    public Experience fromDto(@Nonnull SrsExperienceResponse srsExperienceResponse) {
        DcAccessEntitlements dcAccessEntitlements = this.mapAccessEntitlements(srsExperienceResponse.dcAccessEntitlements());
        return new Experience(srsExperienceResponse.name(), dcAccessEntitlements, srsExperienceResponse.cloudScopes().stream().filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    private DcAccessEntitlements mapAccessEntitlements(SrsAccessEntitlements srs) {
        if (srs == null) {
            return null;
        }
        return new DcAccessEntitlements(this.mapDetail(srs.required()), this.mapDetail(srs.optional()), srs.consentText());
    }

    private DcAccessEntitlementDetail mapDetail(SrsAccessEntitlementDetail srs) {
        if (srs == null) {
            return null;
        }
        Set<String> scopes = srs.scopes() == null ? Set.of() : srs.scopes().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> dataExportEntitlements = srs.dataExportEntitlements() == null ? Set.of() : srs.dataExportEntitlements().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        return new DcAccessEntitlementDetail(srs.description(), scopes, dataExportEntitlements);
    }
}

