/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.entitlements;

import com.atlassian.applinks.core.plugin.DataExportEntitlementModuleDescriptor;
import com.atlassian.applinks.internal.uniconn.entitlements.DataExportEntitlement;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataExportEntitlementMapperService {
    private static final Logger logger = LoggerFactory.getLogger(DataExportEntitlementMapperService.class);
    private final Map<String, Set<DataExportEntitlement>> entitlementsByPlugin = new HashMap<String, Set<DataExportEntitlement>>();
    private final Map<String, DataExportEntitlement> activeEntitlements = new HashMap<String, DataExportEntitlement>();
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;

    @Autowired
    public DataExportEntitlementMapperService(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
        this.refreshDataExportEntitlementMap();
    }

    @PostConstruct
    public void postConstruct() {
        this.pluginEventManager.register((Object)this);
        logger.debug("DataExportEntitlementMapperService: Registered for plugin events");
    }

    @PreDestroy
    public void preDestroy() {
        this.pluginEventManager.unregister((Object)this);
        logger.debug("DataExportEntitlementMapperService: Unregistered from plugin events");
    }

    public void refreshDataExportEntitlementMap() {
        this.entitlementsByPlugin.clear();
        this.activeEntitlements.clear();
        this.pluginAccessor.getEnabledPlugins().forEach(plugin -> plugin.getModuleDescriptors().stream().filter(moduleDescriptor -> moduleDescriptor instanceof DataExportEntitlementModuleDescriptor).forEach(moduleDescriptor -> {
            Optional<Set<DataExportEntitlement>> entitlements = this.parseDataExportEntitlements((ModuleDescriptor<?>)moduleDescriptor);
            entitlements.ifPresent(entitlementSet -> this.entitlementsByPlugin.put(plugin.getKey(), (Set<DataExportEntitlement>)entitlementSet));
        }));
        this.resolveAllConflicts();
    }

    private void addEntitlements(Set<DataExportEntitlement> entitlementsList, String pluginKey) {
        this.entitlementsByPlugin.put(pluginKey, new HashSet<DataExportEntitlement>(entitlementsList));
        entitlementsList.stream().collect(Collectors.groupingBy(DataExportEntitlement::key)).forEach((key, entitlements) -> {
            List<DataExportEntitlement> allForKey = this.getAllEntitlementsForKey((String)key);
            this.resolveConflictForEntitlement((String)key, (Collection<DataExportEntitlement>)allForKey);
        });
    }

    private void removeEntitlements(Set<DataExportEntitlement> entitlementsList, String pluginKey) {
        this.entitlementsByPlugin.remove(pluginKey);
        entitlementsList.stream().collect(Collectors.groupingBy(DataExportEntitlement::key)).forEach((key, entitlements) -> {
            List<DataExportEntitlement> allForKey = this.getAllEntitlementsForKey((String)key);
            this.resolveConflictForEntitlement((String)key, (Collection<DataExportEntitlement>)allForKey);
        });
    }

    private List<DataExportEntitlement> getAllEntitlementsForKey(String key) {
        return this.entitlementsByPlugin.values().stream().flatMap(Collection::stream).filter(e -> key.equals(e.key())).collect(Collectors.toList());
    }

    private void resolveConflictForEntitlement(String entitlementKey, Collection<DataExportEntitlement> allEntitlementsForKey) {
        if (allEntitlementsForKey.isEmpty()) {
            this.activeEntitlements.remove(entitlementKey);
        } else if (allEntitlementsForKey.size() == 1) {
            this.activeEntitlements.put(entitlementKey, allEntitlementsForKey.iterator().next());
        } else {
            DataExportEntitlement winner = allEntitlementsForKey.stream().max(Comparator.comparingInt(DataExportEntitlement::weight).thenComparing(DataExportEntitlement::pluginKey)).orElse(allEntitlementsForKey.iterator().next());
            this.activeEntitlements.put(entitlementKey, winner);
            logger.info("Resolved conflict for entitlement '{}': {} entitlements found, selected winner from plugin '{}' with weight {}", new Object[]{entitlementKey, allEntitlementsForKey.size(), winner.pluginKey(), winner.weight()});
        }
    }

    private void resolveConflictForEntitlement(String entitlementKey) {
        List<DataExportEntitlement> allEntitlements = this.getAllEntitlementsForKey(entitlementKey);
        this.resolveConflictForEntitlement(entitlementKey, allEntitlements);
    }

    private void resolveAllConflicts() {
        Set<String> allKeys = this.entitlementsByPlugin.values().stream().flatMap(Collection::stream).map(DataExportEntitlement::key).collect(Collectors.toSet());
        allKeys.forEach(this::resolveConflictForEntitlement);
    }

    @PluginEventListener
    public void removeEntitlementEvent(PluginModuleDisabledEvent event) {
        ModuleDescriptor moduleDescriptor = event.getModule();
        if (moduleDescriptor instanceof DataExportEntitlementModuleDescriptor) {
            String pluginKey = moduleDescriptor.getPlugin().getKey();
            logger.debug("PluginModule disabled event detected for plugin '{}' - removing data export entitlements", (Object)pluginKey);
            Optional<Set<DataExportEntitlement>> entitlements = this.parseDataExportEntitlements(moduleDescriptor);
            entitlements.ifPresent(entitlementSet -> this.removeEntitlements((Set<DataExportEntitlement>)entitlementSet, pluginKey));
        }
    }

    @PluginEventListener
    public void addEntitlementEvent(PluginModuleEnabledEvent event) {
        ModuleDescriptor moduleDescriptor = event.getModule();
        if (moduleDescriptor instanceof DataExportEntitlementModuleDescriptor) {
            String pluginKey = moduleDescriptor.getPlugin().getKey();
            logger.debug("PluginModule enabled event detected for plugin '{}' - adding data export entitlements", (Object)pluginKey);
            Optional<Set<DataExportEntitlement>> entitlements = this.parseDataExportEntitlements(moduleDescriptor);
            entitlements.ifPresent(entitlementSet -> this.addEntitlements((Set<DataExportEntitlement>)entitlementSet, pluginKey));
        }
    }

    private Optional<Set<DataExportEntitlement>> parseDataExportEntitlements(ModuleDescriptor<?> dataExportEntitlementModuleDescriptor) {
        if (dataExportEntitlementModuleDescriptor instanceof DataExportEntitlementModuleDescriptor) {
            return Optional.of((Set)dataExportEntitlementModuleDescriptor.getModule());
        }
        logger.error("Invalid module descriptor type: " + dataExportEntitlementModuleDescriptor.getClass().getName());
        return Optional.empty();
    }

    public Set<DataExportEntitlement> getAllDataExportEntitlements() {
        return new HashSet<DataExportEntitlement>(this.activeEntitlements.values());
    }

    public Set<DataExportEntitlement> getDataExportEntitlementsByKeys(Set<String> keys) {
        return this.activeEntitlements.values().stream().filter(entitlement -> keys.contains(entitlement.key())).collect(Collectors.toSet());
    }
}

