/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.filter;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.applinks.internal.feature.ApplinksFeatureService;
import com.atlassian.applinks.internal.feature.ApplinksFeatures;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
public class CloudConnectCompanionPluginPageRedirectionFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CloudConnectCompanionPluginPageRedirectionFilter.class);
    private static final String CLOUD_CONNECTIONS_PAGE_PATH = "/plugins/servlet/applinks/listApplicationLinks";
    private static final String CLOUD_CONNECTIONS_PAGE_FRAGMENT = "#tabs-cloud-connections";
    private final ApplinksFeatureService featureService;

    public CloudConnectCompanionPluginPageRedirectionFilter(ApplinksFeatureService featureService) {
        this.featureService = featureService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isFilterEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        StringBuilder redirectUrlBuilder = new StringBuilder().append(httpRequest.getContextPath()).append(CLOUD_CONNECTIONS_PAGE_PATH);
        String queryString = httpRequest.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            redirectUrlBuilder.append("?").append(queryString);
        }
        redirectUrlBuilder.append(CLOUD_CONNECTIONS_PAGE_FRAGMENT);
        String redirectUrl = redirectUrlBuilder.toString();
        LOG.debug("Redirecting from '{}' to '{}'", (Object)httpRequest.getRequestURI(), (Object)redirectUrl);
        httpResponse.sendRedirect(redirectUrl);
    }

    boolean isFilterEnabled() {
        return this.featureService.isEnabled(ApplinksFeatures.UNICONN);
    }

    public void destroy() {
    }
}

