/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.code.config;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.ext.code.config.NewcodeSettingsManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
public final class ConfigureNewcodeAction
extends ConfluenceActionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigureNewcodeAction.class);
    private String defaultLanguageName;
    private String newLanguageName;
    private NewcodeSettingsManager newcodeSettingsManager;

    public void setNewcodeSettingsManager(NewcodeSettingsManager newcodeSettingsManager) {
        this.newcodeSettingsManager = newcodeSettingsManager;
    }

    public boolean getDisplayUpload() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public String getDefaultLanguageName() {
        String defaultLanguage = this.newcodeSettingsManager.getCurrentSettings().getDefaultLanguage();
        if (!StringUtils.isBlank((CharSequence)defaultLanguage)) {
            return defaultLanguage;
        }
        return "Java";
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String input() {
        return "input";
    }

    public String save() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling save event for the Newcode configuration UI");
        }
        if ("".equals(this.defaultLanguageName)) {
            this.defaultLanguageName = null;
        }
        this.newcodeSettingsManager.updateSettings(this.defaultLanguageName);
        this.addActionMessage(this.getText("newcode.config.successfully.saved"));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Save event for the Newcode configuration UI handled");
        }
        return "success";
    }

    public String getActionName(String fullClassName) {
        return "Configure New Code Plugin";
    }

    @StrutsParameter
    public void setDefaultLanguageName(String defaultLanguageName) {
        this.defaultLanguageName = defaultLanguageName;
    }

    @StrutsParameter
    public void setNewLanguageName(String newLanguageName) {
        this.newLanguageName = newLanguageName;
    }
}

