/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.code.config;

import com.atlassian.confluence.ext.code.config.NewcodeSettings;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewcodeSettingsManager {
    private final PluginSettings pluginSettings;

    @Autowired
    public NewcodeSettingsManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public NewcodeSettings getCurrentSettings() {
        Object settings = this.pluginSettings.get("plugin.settings.com.atlassian.confluence.ext.newcode-macro-plugin");
        NewcodeSettings result = new NewcodeSettings();
        if (settings instanceof Map) {
            Map settingsMap = (Map)settings;
            result.mapToSettings(settingsMap);
        }
        return result;
    }

    public void updateSettings(String language) {
        NewcodeSettings newSettings = new NewcodeSettings();
        newSettings.setDefaultLanguage(language);
        this.pluginSettings.put("plugin.settings.com.atlassian.confluence.ext.newcode-macro-plugin", newSettings.settingsToMap());
    }
}

