/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.code.render;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.ext.code.config.NewcodeSettings;
import com.atlassian.confluence.ext.code.config.NewcodeSettingsManager;
import com.atlassian.confluence.ext.code.render.InvalidValueException;
import com.atlassian.confluence.ext.code.render.LanguageParameter;
import com.atlassian.confluence.ext.code.render.ParameterMapper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ContentFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(ContentFormatter.class);
    private final PageBuilderService pageBuilderService;
    private final NewcodeSettingsManager newcodeSettingsManager;
    private final ParameterMapper parameterMapper = new ParameterMapper();

    @Autowired
    public ContentFormatter(@ComponentImport PageBuilderService pageBuilderService, NewcodeSettingsManager newcodeSettingsManager) {
        this.pageBuilderService = pageBuilderService;
        this.newcodeSettingsManager = newcodeSettingsManager;
    }

    public String formatContent(ConversionContext conversionContext, Map<String, String> parameters, String body) throws InvalidValueException {
        boolean isExport = "pdf".equals(conversionContext.getOutputType()) || "word".equals(conversionContext.getOutputType()) || "html_export".equals(conversionContext.getOutputType());
        boolean isMobile = "mobile".equals(conversionContext.getOutputDeviceType());
        LOG.debug("Starting rendering of content");
        String language = LanguageParameter.getPassedValue(parameters);
        if (LanguageParameter.isLanguageEmpty(language)) {
            parameters = new HashMap<String, String>(parameters);
            String defaultLanguage = this.newcodeSettingsManager.getCurrentSettings().getDefaultLanguage();
            parameters.put("language", Objects.requireNonNullElse(defaultLanguage, "Java").toLowerCase());
        }
        Map<String, String> parametersWithDefaults = this.updateParametersWithDefaults(parameters);
        Map<String, String> mappedParameters = this.mapParameters(parametersWithDefaults, isExport);
        String renderedContent = this.createRenderContent(body, mappedParameters);
        LOG.debug("Add web resources needed for rendering");
        if (isMobile) {
            this.requireMobileResources();
        }
        LOG.debug("Rendering of content finished");
        return renderedContent;
    }

    private void requireMobileResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("confluence.macros.newcode.macro.mobile");
    }

    private Map<String, String> updateParametersWithDefaults(Map<String, String> parameters) {
        HashMap<String, String> merged = new HashMap<String, String>(parameters);
        if (merged.containsKey("language")) {
            merged.put("lang", (String)merged.get("language"));
        }
        NewcodeSettings currentSettings = this.newcodeSettingsManager.getCurrentSettings();
        if (!merged.containsKey("lang")) {
            merged.put("lang", currentSettings.getDefaultLanguage());
        }
        return merged;
    }

    private Map<String, String> mapParameters(Map<String, String> parameters, boolean isExport) throws InvalidValueException {
        HashMap<String, String> tmpParameters = new HashMap<String, String>(parameters);
        tmpParameters.put("_isExport", Boolean.toString(isExport));
        LOG.debug("Perform mapping of parameters");
        return this.parameterMapper.mapParameters(tmpParameters);
    }

    private String createRenderContent(String body, Map<String, String> parameters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<pre class=\"syntaxhighlighter-pre\" data-syntaxhighlighter-params=\"");
        boolean first = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!first) {
                buffer.append("; ");
            }
            buffer.append(entry.getKey()).append(": ").append(entry.getValue());
            first = false;
        }
        buffer.append("\">");
        buffer.append(body);
        buffer.append("</pre>");
        return buffer.toString();
    }
}

