/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents.proxy;

import com.atlassian.httpclient.apache.httpcomponents.proxy.ProvidedProxyConfig;
import com.atlassian.httpclient.apache.httpcomponents.proxy.ProxyConfig;
import com.atlassian.httpclient.apache.httpcomponents.proxy.SystemPropertiesProxyConfig;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.api.factory.ProxyOptions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import org.apache.http.HttpHost;

public class ProxyConfigFactory {
    public static Option<HttpHost> getProxyHost(HttpClientOptions options) {
        return (Option)ProxyConfigFactory.getProxyConfig(options).fold(Option::none, ProxyConfig::getProxyHost);
    }

    public static Iterable<ProxyConfig.AuthenticationInfo> getProxyAuthentication(HttpClientOptions options) {
        return (Iterable)ProxyConfigFactory.getProxyConfig(options).fold(Lists::newLinkedList, ProxyConfig::getAuthenticationInfo);
    }

    public static Option<ProxyConfig> getProxyConfig(HttpClientOptions options) {
        return switch (options.getProxyOptions().getProxyMode()) {
            case ProxyOptions.ProxyMode.SYSTEM_PROPERTIES -> Option.some((Object)new SystemPropertiesProxyConfig());
            case ProxyOptions.ProxyMode.CONFIGURED -> Option.some((Object)new ProvidedProxyConfig(options.getProxyOptions().getProxyHosts(), options.getProxyOptions().getNonProxyHosts()));
            default -> Option.none();
        };
    }
}

