/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.roadmap;

import com.atlassian.plugins.roadmap.beans.Roadmap;
import com.atlassian.plugins.roadmap.models.TimelinePlanner;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class TimelinePlannerJsonBuilder {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Gson gson;

    private static Gson getGson() {
        if (gson == null) {
            GsonBuilder roadmapGsonBuilder = new GsonBuilder();
            roadmapGsonBuilder.setDateFormat(DATE_FORMAT);
            gson = roadmapGsonBuilder.create();
        }
        return gson;
    }

    public static TimelinePlanner fromJson(String json) {
        String decodedJson = URLDecoder.decode(json, StandardCharsets.UTF_8);
        return (TimelinePlanner)TimelinePlannerJsonBuilder.getGson().fromJson(decodedJson, TimelinePlanner.class);
    }

    public static Roadmap fromJsonRoadmap(String json) {
        String decodedJson = URLDecoder.decode(json, StandardCharsets.UTF_8);
        return (Roadmap)TimelinePlannerJsonBuilder.getGson().fromJson(decodedJson, Roadmap.class);
    }

    public static String toJson(TimelinePlanner timelinePlanner) {
        String json = TimelinePlannerJsonBuilder.getGson().toJson((Object)timelinePlanner);
        return URLEncoder.encode(json, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static String toJson(Object o) {
        return TimelinePlannerJsonBuilder.getGson().toJson(o);
    }
}

