/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.roadmap.renderer.helper;

import com.atlassian.plugins.roadmap.models.Timeline;
import com.atlassian.plugins.roadmap.renderer.beans.TimelinePosition;
import com.atlassian.plugins.roadmap.renderer.beans.TimelinePositionTitle;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.Weeks;

public class TimeLineHelper {
    private static final String MONTH_KEY_PREFIX = "roadmap.editor.timeline.month";
    private static final long MILLISECONDS_A_DAY = 86400000L;
    private static final long MILLISECONDS_A_WEEK = 604800000L;

    public static List<TimelinePosition> getColumnPosition(Timeline timeline) {
        int month = TimeLineHelper.getMonth(timeline.getStartDate());
        ArrayList<TimelinePosition> roadmapColumns = new ArrayList<TimelinePosition>();
        int numberOfColumn = switch (timeline.getDisplayOption()) {
            case Timeline.DisplayOption.MONTH -> TimeLineHelper.getNumberOfColumnInMonthTimeline(timeline);
            case Timeline.DisplayOption.WEEK -> TimeLineHelper.getNumberOfColumnInWeekTimeline(timeline);
            default -> TimeLineHelper.getNumberOfColumnInDayTimeline(timeline);
        };
        for (int i = 0; i < numberOfColumn; ++i) {
            TimelinePosition timelinePosition = new TimelinePosition(i, 1.0, month);
            roadmapColumns.add(timelinePosition);
        }
        return roadmapColumns;
    }

    public static TimelinePosition calculateTimelinePosition(Timeline timeline, Date date) {
        return switch (timeline.getDisplayOption()) {
            case Timeline.DisplayOption.MONTH -> TimeLineHelper.calculateMonthTimelinePosition(timeline, date);
            case Timeline.DisplayOption.WEEK -> TimeLineHelper.calculateWeekTimelinePosition(timeline, date);
            default -> TimeLineHelper.calculateDayTimelinePosition(timeline, date);
        };
    }

    private static TimelinePosition calculateMonthTimelinePosition(Timeline timeline, Date date) {
        int startMonthNumber = TimeLineHelper.getMonth(timeline.getStartDate());
        Date firstDateOfMonth = DateUtils.truncate((Date)date, (int)2);
        int numberOfMonths = TimeLineHelper.monthDiff(timeline.getStartDate(), date);
        long numberMilisecondFromStartMonth = date.getTime() - firstDateOfMonth.getTime();
        long numberMilisecondInMonth = TimeLineHelper.getMillisecondInMonth(date);
        double offset = (double)numberMilisecondFromStartMonth / (double)numberMilisecondInMonth;
        return new TimelinePosition(numberOfMonths, offset, startMonthNumber);
    }

    private static TimelinePosition calculateWeekTimelinePosition(Timeline timeline, Date date) {
        Date timelineStartWeek = TimeLineHelper.getStartDateOfWeek(timeline.getStartDate());
        Date startWeek = TimeLineHelper.getStartDateOfWeek(date);
        int numberOfWeeks = TimeLineHelper.weekDiff(timelineStartWeek, startWeek);
        long numberMilisecondFromStartWeek = date.getTime() - startWeek.getTime();
        double offset = (double)numberMilisecondFromStartWeek / 6.048E8;
        return new TimelinePosition(numberOfWeeks, offset, numberOfWeeks);
    }

    private static TimelinePosition calculateDayTimelinePosition(Timeline timeline, Date date) {
        Date timelineStartDay = timeline.getStartDate();
        int numberOfDays = TimeLineHelper.daysDiff(timelineStartDay, date);
        long numberMilisecondFromStartDay = date.getTime() - date.getTime();
        double offset = (double)numberMilisecondFromStartDay / 8.64E7;
        return new TimelinePosition(numberOfDays, offset, numberOfDays);
    }

    public static TimelinePositionTitle getPositionTitle(Timeline timeline, TimelinePosition timelinePosition, I18nResolver i18n) {
        return switch (timeline.getDisplayOption()) {
            case Timeline.DisplayOption.MONTH -> TimeLineHelper.getMonthPositionTitle(timeline, timelinePosition, i18n);
            case Timeline.DisplayOption.WEEK -> TimeLineHelper.getWeekPositionTitle(timeline, timelinePosition, i18n);
            default -> TimeLineHelper.getDayPositionTitle(timeline, timelinePosition, i18n);
        };
    }

    private static TimelinePositionTitle getMonthPositionTitle(Timeline timeline, TimelinePosition timelinePosition, I18nResolver i18n) {
        int month = (timelinePosition.getColumn() + timelinePosition.getColumnOffset()) % 12;
        String monthString = i18n.getText(MONTH_KEY_PREFIX + (month + 1));
        Calendar startTime = TimeLineHelper.getCalendar(timeline.getStartDate());
        int year = startTime.get(1) + (timelinePosition.getColumn() + timelinePosition.getColumnOffset()) / 12;
        return new TimelinePositionTitle(monthString, String.valueOf(year));
    }

    private static TimelinePositionTitle getWeekPositionTitle(Timeline timeline, TimelinePosition timelinePosition, I18nResolver i18n) {
        Date startDate = TimeLineHelper.getStartDateOfWeek(timeline.getStartDate());
        Calendar calendar = TimeLineHelper.getCalendar(startDate);
        calendar.add(5, timelinePosition.getColumn() * 7);
        String timelineTitle = TimeLineHelper.getWeekTimelineTitle(calendar, i18n);
        int year = calendar.get(1);
        return new TimelinePositionTitle(timelineTitle, String.valueOf(year));
    }

    private static TimelinePositionTitle getDayPositionTitle(Timeline timeline, TimelinePosition timelinePosition, I18nResolver i18n) {
        Date startDate = timeline.getStartDate();
        Calendar calendar = TimeLineHelper.getCalendar(startDate);
        calendar.add(5, timelinePosition.getColumn());
        String timelineTitle = TimeLineHelper.getDayTimelineTitle(calendar, i18n);
        int year = calendar.get(1);
        return new TimelinePositionTitle(timelineTitle, String.valueOf(year));
    }

    public static int getNumberOfColumnInTimeline(Timeline timeline) {
        return switch (timeline.getDisplayOption()) {
            case Timeline.DisplayOption.MONTH -> TimeLineHelper.getNumberOfColumnInMonthTimeline(timeline);
            case Timeline.DisplayOption.WEEK -> TimeLineHelper.getNumberOfColumnInWeekTimeline(timeline);
            default -> TimeLineHelper.getNumberOfColumnInDayTimeline(timeline);
        };
    }

    private static int getNumberOfColumnInMonthTimeline(Timeline timeline) {
        return Math.max(TimeLineHelper.monthDiff(timeline.getStartDate(), timeline.getEndDate()) + 1, 1);
    }

    private static int getNumberOfColumnInWeekTimeline(Timeline timeline) {
        Date startDate = TimeLineHelper.getStartDateOfWeek(timeline.getStartDate());
        Date endDate = TimeLineHelper.getEndDateOfWeek(timeline.getEndDate());
        return TimeLineHelper.weekDiff(startDate, endDate) + 1;
    }

    private static int getNumberOfColumnInDayTimeline(Timeline timeline) {
        Date startDate = timeline.getStartDate();
        Date endDate = timeline.getEndDate();
        return TimeLineHelper.daysDiff(startDate, endDate) + 1;
    }

    private static Calendar getCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private static int getMonth(Date date) {
        Calendar startTime = TimeLineHelper.getCalendar(date);
        return startTime.get(2);
    }

    private static long getMillisecondInMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int numberOfDay = calendar.getActualMaximum(5);
        return (long)numberOfDay * 86400000L;
    }

    private static int monthDiff(Date startDate, Date endDate) {
        Calendar startTime = TimeLineHelper.getCalendar(startDate);
        Calendar endTime = TimeLineHelper.getCalendar(endDate);
        int diffYear = endTime.get(1) - startTime.get(1);
        return diffYear * 12 + endTime.get(2) - startTime.get(2);
    }

    private static int weekDiff(Date date1, Date date2) {
        DateTime dateTime1 = new DateTime((Object)date1);
        DateTime dateTime2 = new DateTime((Object)date2);
        return Weeks.weeksBetween((ReadableInstant)dateTime1, (ReadableInstant)dateTime2).getWeeks();
    }

    private static int daysDiff(Date date1, Date date2) {
        DateTime dateTime1 = new DateTime((Object)date1);
        DateTime dateTime2 = new DateTime((Object)date2);
        return Days.daysBetween((ReadableInstant)dateTime1, (ReadableInstant)dateTime2).getDays();
    }

    private static Date getStartDateOfWeek(Date date) {
        Calendar calendar = TimeLineHelper.getCalendar(date);
        int day = calendar.get(7);
        day = day == 1 ? -6 : 2 - day;
        calendar.add(5, day);
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        calendar.set(14, calendar.getActualMinimum(14));
        return calendar.getTime();
    }

    private static Date getEndDateOfWeek(Date date) {
        Calendar calendar = TimeLineHelper.getCalendar(date);
        int day = calendar.get(7);
        day = day == 1 ? 0 : 8 - day;
        calendar.add(5, day);
        return calendar.getTime();
    }

    private static String getWeekTimelineTitle(Calendar calendar, I18nResolver i18n) {
        StringBuilder weekTimelineTitle = new StringBuilder();
        weekTimelineTitle.append(String.format("%02d", calendar.get(5)));
        weekTimelineTitle.append("-");
        weekTimelineTitle.append(i18n.getText(MONTH_KEY_PREFIX + (calendar.get(2) + 1)));
        return weekTimelineTitle.toString();
    }

    private static String getDayTimelineTitle(Calendar calendar, I18nResolver i18n) {
        StringBuilder dayTimelineTitle = new StringBuilder();
        dayTimelineTitle.append(String.format("%02d", calendar.get(5)));
        dayTimelineTitle.append("-");
        dayTimelineTitle.append(i18n.getText(MONTH_KEY_PREFIX + (calendar.get(2) + 1)));
        return dayTimelineTitle.toString();
    }
}

