/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.roadmap.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.plugins.roadmap.BarParam;
import com.atlassian.plugins.roadmap.PageLinkParser;
import com.atlassian.plugins.roadmap.TimelinePlannerJsonBuilder;
import com.atlassian.plugins.roadmap.TimelinePlannerMacroManager;
import com.atlassian.plugins.roadmap.models.RoadmapPageLink;
import com.google.gson.JsonObject;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.LinkedHashMap;
import java.util.Map;

@Path(value="/")
public class TimelinePlannerResource {
    private final TimelinePlannerMacroManager timelinePlannerMacroManager;
    private final PageLinkParser linkParser;

    @Inject
    public TimelinePlannerResource(TimelinePlannerMacroManager timelinePlannerMacroManager, PageLinkParser pageLinkParser) {
        this.timelinePlannerMacroManager = timelinePlannerMacroManager;
        this.linkParser = pageLinkParser;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="bar/{barId}/status")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getBarStatus(@PathParam(value="barId") String barId) {
        TimelinePlannerMacroManager.LinkStatus linkStatus = this.timelinePlannerMacroManager.checkStatus(barId);
        JsonObject json = new JsonObject();
        json.addProperty("status", String.valueOf((Object)linkStatus));
        if (linkStatus == TimelinePlannerMacroManager.LinkStatus.REDEEM) {
            json.addProperty("pageLink", TimelinePlannerJsonBuilder.toJson(this.timelinePlannerMacroManager.getBarPageLink(barId)));
            this.timelinePlannerMacroManager.removeStatus(barId);
            this.timelinePlannerMacroManager.removeBarPageLink(barId);
        }
        return Response.ok((Object)json.toString()).build();
    }

    @PUT
    @Path(value="bar/{barId}/{status}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response putBarStatus(@PathParam(value="status") String status, @PathParam(value="barId") String barId) {
        this.timelinePlannerMacroManager.put(barId, TimelinePlannerMacroManager.LinkStatus.valueOf(status));
        return Response.ok().build();
    }

    @POST
    @Path(value="bar/pagelink/reset")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response resetBarPageLink(Map context) {
        if (!this.validateBarContextMap(context)) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        this.timelinePlannerMacroManager.updatePagelinkToRoadmapBar(BarParam.fromMap(context), new RoadmapPageLink());
        return Response.ok().build();
    }

    @POST
    @Path(value="bar/pagelink/dolink")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response linkPageToBar(Map context) {
        if (!this.validateBarContextMap(context)) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        String linkedPageId = (String)context.get("linkedPageId");
        this.timelinePlannerMacroManager.updatePagelinkToRoadmapBar(BarParam.fromMap(context), Long.parseLong(linkedPageId));
        return Response.ok().build();
    }

    @POST
    @Path(value="extractPageLinks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response extractPageLinks(Map linkData) {
        String currentSpaceKey = linkData.get("roadmapSpace").toString();
        Map wikiLinks = (Map)linkData.get("wikiLinks");
        LinkedHashMap<String, RoadmapPageLink> pageLinks = new LinkedHashMap<String, RoadmapPageLink>();
        for (String key : wikiLinks.keySet()) {
            pageLinks.put(key, this.linkParser.resolveConfluenceLink((String)wikiLinks.get(key), currentSpaceKey));
        }
        return Response.ok(pageLinks).build();
    }

    private boolean validateBarContextMap(Map contextMap) {
        return contextMap.containsKey("roadmapContentId") && contextMap.containsKey("version") && contextMap.containsKey("roadmapHash") && contextMap.containsKey("roadmapBarId");
    }
}

