/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.roadmap.upgradetask;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.migration.AbstractExceptionTolerantMigrator;
import com.atlassian.confluence.content.render.xhtml.migration.ExceptionTolerantMigrator;
import com.atlassian.confluence.content.render.xhtml.migration.exceptions.MigrationException;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.query.MacroUsageQuery;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugins.roadmap.upgradetask.ContentEntityMigrationBatchTask;
import com.atlassian.plugins.roadmap.upgradetask.ScanSearchResult;
import com.atlassian.plugins.roadmap.upgradetask.SearchResultsBatchWorkSource;
import com.atlassian.plugins.roadmap.upgradetask.WorkSourceBatchRunner;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CurrentSpacesParamMigrator {
    private static final Logger log = LoggerFactory.getLogger(CurrentSpacesParamMigrator.class);
    public static final String BATCH_SIZE_PROPERTY_NAME = "confluence.roadmap.migrator.batch.size";
    private static final String CURRENT_SPACES_PARAM = "currentspaces";
    private final SearchManager searchManager;
    private final CustomContentManager contentManager;
    private final TransactionTemplate transactionTemplate;
    private final XhtmlContent xhtmlContent;
    private volatile boolean inProgress = false;
    private AtomicInteger numFailed;
    private AtomicInteger numMigrated;
    private AtomicInteger numMigrationNotRequired;
    private int totalBatches;
    private final int batchSize;
    private final Function<Searchable, ContentEntityObject> searchableToCEOTransformer = from -> {
        BodyContent bodyContent;
        if (from instanceof ContentEntityObject && (bodyContent = ((ContentEntityObject)from).getBodyContent()).getBodyType().equals((Object)BodyType.XHTML)) {
            return (ContentEntityObject)from;
        }
        return null;
    };

    public CurrentSpacesParamMigrator(XhtmlContent xhtmlContent, SearchManager searchManager, CustomContentManager contentManager, TransactionTemplate transactionTemplate) {
        this.contentManager = contentManager;
        this.searchManager = searchManager;
        this.xhtmlContent = xhtmlContent;
        this.transactionTemplate = transactionTemplate;
        this.batchSize = Integer.getInteger(BATCH_SIZE_PROPERTY_NAME, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate() throws MigrationException {
        CurrentSpacesParamMigrator currentSpacesParamMigrator = this;
        synchronized (currentSpacesParamMigrator) {
            if (this.inProgress) {
                throw new IllegalStateException("Another 'currentspaces' parameter migration is currently in progress");
            }
            this.resetMigrationFlags();
        }
        try {
            this.doMigration();
        }
        catch (InvalidSearchException e) {
            throw new MigrationException("Error searching for macro usages", (Throwable)e);
        }
        catch (Exception e) {
            throw new MigrationException((Throwable)e);
        }
        finally {
            this.inProgress = false;
        }
    }

    @VisibleForTesting
    public int getTotalBatches() {
        return this.totalBatches;
    }

    private void resetMigrationFlags() {
        this.inProgress = true;
        this.numFailed = new AtomicInteger(0);
        this.numMigrated = new AtomicInteger(0);
        this.numMigrationNotRequired = new AtomicInteger(0);
        this.totalBatches = 0;
    }

    private void doMigration() throws Exception {
        log.info("Started migration of Roadmap macros");
        try (WorkSourceBatchRunner<ContentEntityObject> batchRunner = new WorkSourceBatchRunner<ContentEntityObject>(this.transactionTemplate);){
            this.migrateCurrentContents(batchRunner);
        }
        log.info("Finished migration of Roadmap macros:\n{} Roadmap macro(s) were updated\n{} Roadmap macro(s) did not require any changes\n{} Roadmap macro(s) could not be updated\n", new Object[]{this.numMigrated, this.numMigrationNotRequired, this.numFailed});
    }

    private void migrateCurrentContents(WorkSourceBatchRunner<ContentEntityObject> batchRunner) throws InvalidSearchException, ExecutionException, InterruptedException {
        log.info("Start migrate which using searchManager#scan");
        ArrayList futures = new ArrayList();
        BatchingSearchResultConsumer batchingSearchResultConsumer = new BatchingSearchResultConsumer(this.searchManager, this.searchableToCEOTransformer, this.contentManager, batchRunner, this.batchSize, futures::addAll);
        SearchScanDocumentConsumer searchScanDocumentConsumer = new SearchScanDocumentConsumer(this, batchingSearchResultConsumer);
        MacroUsageQuery query = new MacroUsageQuery("roadmap");
        this.searchManager.scan(Collections.singletonList(Index.CONTENT), (SearchQuery)query, Set.of(SearchFieldMappings.HANDLE.getName(), SearchFieldMappings.CONTENT_VERSION.getName()), (Consumer)searchScanDocumentConsumer);
        batchingSearchResultConsumer.processBatch();
        this.totalBatches = batchingSearchResultConsumer.getTotalBatches();
        for (Future future : futures) {
            future.get();
        }
    }

    private class BatchingSearchResultConsumer
    implements Consumer<SearchResult> {
        private List<SearchResult> searchResults;
        private final SearchManager searchManager;
        private final Function<Searchable, ContentEntityObject> searchableToCEOTransformer;
        private final CustomContentManager customContentManager;
        private final WorkSourceBatchRunner<ContentEntityObject> batchRunner;
        private final Consumer<List<Future<List<Exception>>>> futuresConsumer;
        private final int batchSize;
        private final AtomicInteger totalBatches;

        public BatchingSearchResultConsumer(SearchManager searchManager, Function<Searchable, ContentEntityObject> searchableToCEOTransformer, CustomContentManager customContentManager, WorkSourceBatchRunner<ContentEntityObject> batchRunner, int batchSize, Consumer<List<Future<List<Exception>>>> futuresConsumer) {
            this.searchManager = searchManager;
            this.searchableToCEOTransformer = searchableToCEOTransformer;
            this.customContentManager = customContentManager;
            this.batchRunner = batchRunner;
            this.batchSize = batchSize;
            this.searchResults = new ArrayList<SearchResult>(batchSize);
            this.futuresConsumer = futuresConsumer;
            this.totalBatches = new AtomicInteger(0);
        }

        @VisibleForTesting
        public int getTotalBatches() {
            return this.totalBatches.get();
        }

        @Override
        public void accept(SearchResult searchResult) {
            this.searchResults.add(searchResult);
            if (this.searchResults.size() == this.batchSize) {
                this.processBatch();
            }
        }

        private List<SearchResult> getCurrentBatch() {
            ArrayList<SearchResult> currentBatch = new ArrayList<SearchResult>(this.searchResults);
            this.searchResults = new ArrayList<SearchResult>(this.batchSize);
            return currentBatch;
        }

        public void processBatch() {
            List<SearchResult> currentBatch = this.getCurrentBatch();
            if (currentBatch.isEmpty()) {
                log.info("Current batch is empty. Skip processing it");
                return;
            }
            log.info("Processing new batch with size {} with current batch {}", (Object)currentBatch.size(), (Object)this.totalBatches.incrementAndGet());
            SearchResultsBatchWorkSource<ContentEntityObject> workSource = new SearchResultsBatchWorkSource<ContentEntityObject>(this.searchManager, currentBatch, this.batchSize, this.searchableToCEOTransformer::apply);
            ContentEntityMigrationBatchTask batchTask = new ContentEntityMigrationBatchTask((ExceptionTolerantMigrator)new RoadmapMacroParamsContentEntityMigrator(), (ContentEntityManager)this.customContentManager);
            this.futuresConsumer.accept(this.batchRunner.runAsync(workSource, batchTask));
        }
    }

    private class SearchScanDocumentConsumer
    implements Consumer<Map<String, String[]>> {
        private final Consumer<SearchResult> searchResultConsumer;

        public SearchScanDocumentConsumer(CurrentSpacesParamMigrator currentSpacesParamMigrator, Consumer<SearchResult> searchResultConsumer) {
            this.searchResultConsumer = searchResultConsumer;
        }

        @Override
        public void accept(Map<String, String[]> rawDocument) {
            if (rawDocument == null) {
                log.warn("There is a null rawDocument");
                return;
            }
            this.searchResultConsumer.accept((SearchResult)new ScanSearchResult(rawDocument));
        }
    }

    class RoadmapMacroParamsContentEntityMigrator
    extends AbstractExceptionTolerantMigrator {
        RoadmapMacroParamsContentEntityMigrator() {
        }

        public ExceptionTolerantMigrator.MigrationResult migrate(String content, ConversionContext conversionContext) {
            try {
                ArrayList migrations = new ArrayList();
                String migratedContent = CurrentSpacesParamMigrator.this.xhtmlContent.updateMacroDefinitions(content, conversionContext, macroDefinition -> {
                    if (StringUtils.equals((CharSequence)macroDefinition.getName(), (CharSequence)"roadmap")) {
                        Map params = macroDefinition.getParameters();
                        if (params.containsKey(CurrentSpacesParamMigrator.CURRENT_SPACES_PARAM)) {
                            migrations.add(true);
                            this.processParams(macroDefinition);
                            CurrentSpacesParamMigrator.this.numMigrated.incrementAndGet();
                        } else {
                            CurrentSpacesParamMigrator.this.numMigrationNotRequired.incrementAndGet();
                        }
                    }
                    return macroDefinition;
                });
                return new ExceptionTolerantMigrator.MigrationResult(migratedContent, !migrations.isEmpty());
            }
            catch (XhtmlException e) {
                log.info("Encountered an exception during Roadmap macro migration", (Throwable)e);
                CurrentSpacesParamMigrator.this.numFailed.incrementAndGet();
                return new ExceptionTolerantMigrator.MigrationResult(content, false);
            }
        }

        private void processParams(MacroDefinition macroDefinition) {
            macroDefinition.setParameter(CurrentSpacesParamMigrator.CURRENT_SPACES_PARAM, null);
            macroDefinition.setTypedParameter(CurrentSpacesParamMigrator.CURRENT_SPACES_PARAM, null);
        }
    }
}

