/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.roadmap.upgradetask;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.content.render.xhtml.migration.BatchableWorkSource;
import com.atlassian.confluence.search.v2.DefaultSearchResults;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

class SearchResultsBatchWorkSource<T>
implements BatchableWorkSource<T> {
    private final SearchManager searchManager;
    private final List<SearchResult> searchResults;
    private final int batchSize;
    private final Function<Searchable, T> transformer;
    private final AtomicInteger offset = new AtomicInteger();

    public SearchResultsBatchWorkSource(SearchManager searchManager, List<SearchResult> searchResults, int batchSize, Function<Searchable, T> transformer) {
        this.searchManager = searchManager;
        this.searchResults = Collections.unmodifiableList(searchResults);
        this.batchSize = batchSize <= 0 ? 1 : batchSize;
        this.transformer = transformer;
    }

    public List<T> getBatch() {
        int newOffset;
        int oldOffset;
        while (!this.offset.compareAndSet(oldOffset = this.offset.get(), newOffset = oldOffset + this.batchSize)) {
        }
        if (oldOffset >= this.searchResults.size()) {
            return Collections.emptyList();
        }
        int endIndex = Math.min(newOffset, this.searchResults.size());
        List searchables = this.searchManager.convertToEntities((SearchResults)new DefaultSearchResults(this.searchResults.subList(oldOffset, endIndex), this.batchSize), SearchManager.EntityVersionPolicy.INDEXED_VERSION);
        return searchables.stream().map(this.transformer).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean hasMoreBatches() {
        return this.offset.get() < this.searchResults.size();
    }

    public int numberOfBatches() {
        int totalSize = this.getTotalSize();
        int totalBatch = totalSize / this.batchSize;
        if (totalSize % this.batchSize > 0) {
            ++totalBatch;
        }
        return totalBatch;
    }

    public void reset(int total) {
        this.offset.set(0);
    }

    public int getTotalSize() {
        return this.searchResults.size();
    }
}

