/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.roadmap.upgradetask;

import com.atlassian.confluence.content.render.xhtml.migration.BatchException;
import com.atlassian.confluence.content.render.xhtml.migration.BatchTask;
import com.atlassian.confluence.content.render.xhtml.migration.BatchableWorkSource;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import io.atlassian.util.concurrent.ThreadFactories;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class WorkSourceBatchRunner<T>
implements Closeable {
    private static final String THREAD_NAME = "roadmap-macro-migration";
    private static final int NUM_THREADS = 4;
    private final TransactionTemplate transactionTemplate;
    private final ExecutorService executor;

    public WorkSourceBatchRunner(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
        this.executor = Executors.newFixedThreadPool(4, ThreadFactories.namedThreadFactory((String)THREAD_NAME, (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
    }

    protected List<Exception> run(BatchableWorkSource<T> workSource, BatchTask<T> task, ExecutorService executor) throws ExecutionException, InterruptedException {
        List<Future<List<Exception>>> futures = this.runAsync(workSource, task, executor);
        ArrayList<Exception> allExceptions = new ArrayList<Exception>(1);
        for (Future<List<Exception>> future : futures) {
            allExceptions.addAll((Collection<Exception>)future.get());
        }
        return allExceptions;
    }

    protected List<Future<List<Exception>>> runAsync(BatchableWorkSource<T> workSource, BatchTask<T> task, ExecutorService executor) {
        ArrayList<Future<List<Exception>>> futures = new ArrayList<Future<List<Exception>>>(workSource.numberOfBatches());
        for (int i = 0; i < workSource.numberOfBatches(); ++i) {
            futures.add(executor.submit(() -> {
                ArrayList exceptions = new ArrayList(1);
                this.transactionTemplate.execute(() -> {
                    List batch = workSource.getBatch();
                    int size = batch.size();
                    for (int i1 = 0; i1 < size; ++i1) {
                        try {
                            task.apply(batch.get(i1), i1, batch.size());
                            continue;
                        }
                        catch (BatchException ex) {
                            exceptions.addAll(ex.getBatchExceptions());
                            continue;
                        }
                        catch (Exception ex) {
                            exceptions.add(ex);
                        }
                    }
                    return null;
                });
                return exceptions;
            }));
        }
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Exception> run(BatchableWorkSource<T> workSource, BatchTask<T> task) throws ExecutionException, InterruptedException {
        List<Exception> exceptions;
        ExecutorService oneTimeExecutor = Executors.newFixedThreadPool(4, ThreadFactories.namedThreadFactory((String)THREAD_NAME, (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
        try {
            exceptions = this.run(workSource, task, oneTimeExecutor);
        }
        finally {
            oneTimeExecutor.shutdown();
        }
        return exceptions;
    }

    public List<Future<List<Exception>>> runAsync(BatchableWorkSource<T> workSource, BatchTask<T> task) {
        return this.runAsync(workSource, task, this.executor);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

