/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.dmz.persistence.EntityManagerProvider;
import com.atlassian.confluence.pages.AbstractPage;
import com.google.common.base.Preconditions;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PersistenceUnitUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceEvictor {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceEvictor.class);
    private final EntityManagerProvider entityManagerProvider;

    public ConfluenceEvictor(EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = (EntityManagerProvider)Preconditions.checkNotNull((Object)entityManagerProvider);
    }

    public void apply(ConfluenceEntityObject entity) {
        this.apply(entity, true, true);
    }

    public void apply(ConfluenceEntityObject entity, boolean clearL1Cache, boolean clearL2Cache) {
        if (clearL1Cache) {
            this.detach(entity);
        }
        if (clearL2Cache) {
            this.evict(entity);
        }
    }

    public void evict(ConfluenceEntityObject entity) {
        if (!(entity instanceof AbstractPage)) {
            return;
        }
        try {
            EntityManager entityManager = this.entityManagerProvider.entityManager();
            EntityManagerFactory entityManagerFactory = entityManager.getEntityManagerFactory();
            Optional.ofNullable(entityManagerFactory.getCache()).ifPresent(cache -> cache.evict(entity.getClass(), (Object)entity.getId()));
        }
        catch (PersistenceException | IllegalStateException e) {
            log.warn("Failed to evict the entity from L2 cache", e);
        }
    }

    public void detach(ConfluenceEntityObject entity) {
        if (!(entity instanceof AbstractPage)) {
            return;
        }
        AbstractPage page = (AbstractPage)entity;
        try {
            EntityManager entityManager = this.entityManagerProvider.entityManager();
            if (entityManager.contains((Object)entity)) {
                entityManager.detach((Object)entity);
            }
            this.detachPageBodyContent((ConfluenceEntityObject)page);
        }
        catch (PersistenceException | IllegalStateException e) {
            log.warn("Failed to detach the entity from L1 cache", e);
        }
    }

    public void detachPageBodyContent(ConfluenceEntityObject entity) {
        if (!(entity instanceof AbstractPage)) {
            return;
        }
        AbstractPage page = (AbstractPage)entity;
        try {
            EntityManager entityManager = this.entityManagerProvider.entityManager();
            PersistenceUnitUtil util = entityManager.getEntityManagerFactory().getPersistenceUnitUtil();
            if (util.isLoaded((Object)entity, "bodyContents")) {
                page.getBodyContents().stream().forEach(bc -> {
                    if (entityManager.contains(bc)) {
                        entityManager.detach(bc);
                    }
                });
            }
        }
        catch (PersistenceException | IllegalStateException e) {
            log.warn("Failed to detach the entity from L1 cache", e);
        }
    }
}

