/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.streams.spi.FormatPreferenceProvider;
import com.google.common.base.Preconditions;
import java.time.ZoneId;

public class ConfluenceFormatPreferenceProvider
implements FormatPreferenceProvider {
    private final FormatSettingsManager formatSettingsManager;
    private final UserPreferencesAccessor userPreferencesAccessor;

    public ConfluenceFormatPreferenceProvider(FormatSettingsManager formatSettingsManager, UserPreferencesAccessor userPreferencesAccessor) {
        this.formatSettingsManager = (FormatSettingsManager)Preconditions.checkNotNull((Object)formatSettingsManager, (Object)"formatSettingsManager");
        this.userPreferencesAccessor = (UserPreferencesAccessor)Preconditions.checkNotNull((Object)userPreferencesAccessor, (Object)"userPreferencesAccessor");
    }

    public String getTimeFormatPreference() {
        return this.formatSettingsManager.getTimeFormat();
    }

    public String getDateFormatPreference() {
        return this.formatSettingsManager.getDateFormat();
    }

    public String getDateTimeFormatPreference() {
        return this.formatSettingsManager.getDateTimeFormat();
    }

    public ZoneId getUserTimeZoneId() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        UserPreferences userPreferences = this.userPreferencesAccessor.getUserPreferences(user);
        return userPreferences.getTimeZone().getWrappedTimeZone().toZoneId();
    }

    public boolean getDateRelativizePreference() {
        return true;
    }
}

