/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence;

import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.confluence.ConfluenceWatchHelper;
import com.atlassian.streams.confluence.ConfluenceWatchInlineActionHandler;
import com.atlassian.user.User;
import com.google.common.base.Function;
import java.util.List;
import java.util.Objects;

public class ConfluenceWatchSpaceInlineActionHandler
implements ConfluenceWatchInlineActionHandler<String> {
    private final NotificationManager notificationManager;
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final ConfluenceWatchHelper<Space, Long> watchHelper = new ConfluenceWatchHelper();

    public ConfluenceWatchSpaceInlineActionHandler(NotificationManager notificationManager, SpaceManager spaceManager, PermissionManager permissionManager) {
        this.notificationManager = Objects.requireNonNull(notificationManager, "notificationManager");
        this.spaceManager = Objects.requireNonNull(spaceManager, "spaceManager");
        this.permissionManager = Objects.requireNonNull(permissionManager, "permissionManager");
    }

    @Override
    public boolean startWatching(String key) {
        Space space = this.spaceManager.getSpace(key);
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)space)) {
            return false;
        }
        if (user != null && this.notificationManager.isUserWatchingPageOrSpace((User)user, space, null)) {
            return true;
        }
        return this.watchHelper.startWatching(space, (Function<Pair<User, Space>, Void>)((Function)this::addSpaceNotification), (Function<Space, List<Notification>>)((Function)this::getSpaceNotifications));
    }

    private Void addSpaceNotification(Pair<User, Space> params) {
        this.notificationManager.addSpaceNotification((User)params.first(), (Space)params.second(), null);
        return null;
    }

    private List<Notification> getSpaceNotifications(Space space) {
        return this.notificationManager.getNotificationsBySpaceAndType(space, null);
    }
}

