/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence;

import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.streams.spi.StreamsKeyProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Objects;

public class SpaceKeys {
    private final SpaceManager spaceManager;
    private final TransactionTemplate transactionTemplate;
    private Comparator<Space> spaceSorter = (space1, space2) -> {
        if (space1.getSpaceType().equals((Object)SpaceType.PERSONAL) && space2.getSpaceType().equals((Object)SpaceType.GLOBAL)) {
            return 1;
        }
        if (space1.getSpaceType().equals((Object)SpaceType.GLOBAL) && space2.getSpaceType().equals((Object)SpaceType.PERSONAL)) {
            return -1;
        }
        return space1.getName().compareToIgnoreCase(space2.getName());
    };

    public SpaceKeys(SpaceManager spaceManager, TransactionTemplate transactionTemplate) {
        this.spaceManager = Objects.requireNonNull(spaceManager, "spaceManager");
        this.transactionTemplate = Objects.requireNonNull(transactionTemplate, "transactionTemplate");
    }

    public Iterable<StreamsKeyProvider.StreamsKey> get() {
        return ImmutableList.builder().addAll(this.spaceKeys()).build();
    }

    private Iterable<StreamsKeyProvider.StreamsKey> spaceKeys() {
        return Iterables.transform(this.fetchSpaces(), this::toStreamsKey);
    }

    private StreamsKeyProvider.StreamsKey toStreamsKey(Space space) {
        return new StreamsKeyProvider.StreamsKey(space.getKey(), space.getName());
    }

    private Iterable<Space> fetchSpaces() {
        return (Iterable)this.transactionTemplate.execute(() -> {
            SpacesQuery spacesQuery = SpacesQuery.newQuery().forUser(AuthenticatedUserThreadLocal.get()).build();
            ListBuilder spaces = this.spaceManager.getSpaces(spacesQuery);
            return Ordering.from(this.spaceSorter).sortedCopy((Iterable)spaces.getRange(0, spaces.getAvailableSize()));
        });
    }
}

