/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence.changereport;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;

public class CanCommentPredicateFactory {
    private final PermissionManager permissionManager;
    private final ConfluenceUserResolver userResolver;

    public CanCommentPredicateFactory(PermissionManager permissionManager, ConfluenceUserResolver userResolver) {
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.userResolver = (ConfluenceUserResolver)Preconditions.checkNotNull((Object)userResolver, (Object)"userResolver");
    }

    Predicate<String> canCommentOn(AbstractPage abstractPage) {
        return username -> this.permissionManager.hasCreatePermission(this.userResolver.getUserByName(username), (Object)abstractPage, Comment.class);
    }

    Predicate<String> canCommentOn(Comment comment) {
        return username -> this.permissionManager.hasCreatePermission(this.userResolver.getUserByName(username), (Object)comment.getContainer(), Comment.class);
    }
}

