/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence.rest.resources;

import com.atlassian.streams.confluence.ConfluenceWatchInlineActionHandler;
import com.atlassian.streams.confluence.ConfluenceWatchPageInlineActionHandler;
import com.atlassian.streams.confluence.ConfluenceWatchSpaceInlineActionHandler;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;

@Path(value="/actions")
public class ConfluenceInlineActionResource {
    private final ConfluenceWatchPageInlineActionHandler pageWatchHandler;
    private final ConfluenceWatchSpaceInlineActionHandler spaceWatchHandler;

    @Inject
    public ConfluenceInlineActionResource(ConfluenceWatchPageInlineActionHandler pageWatchHandler, ConfluenceWatchSpaceInlineActionHandler spaceWatchHandler) {
        this.pageWatchHandler = (ConfluenceWatchPageInlineActionHandler)Preconditions.checkNotNull((Object)pageWatchHandler, (Object)"pageWatchHandler");
        this.spaceWatchHandler = (ConfluenceWatchSpaceInlineActionHandler)Preconditions.checkNotNull((Object)spaceWatchHandler, (Object)"spaceWatchHandler");
    }

    @Path(value="page-watch/{key}")
    @POST
    public Response watchPage(@PathParam(value="key") Long key) {
        return this.watchEntity(this.pageWatchHandler, key);
    }

    @Path(value="space-watch/{key}")
    @POST
    public Response watchSpace(@PathParam(value="key") String key) {
        return this.watchEntity(this.spaceWatchHandler, key);
    }

    private <K> Response watchEntity(ConfluenceWatchInlineActionHandler<K> handler, K key) {
        boolean success = handler.startWatching(key);
        if (success) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
    }
}

