/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.whatsnew;

import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.user.User;
import com.google.common.base.Objects;
import jakarta.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhatsNewManager {
    private static final Logger log = LoggerFactory.getLogger(WhatsNewManager.class);
    private static final Pattern MAJOR_VERSION_PATTERN = Pattern.compile("^(\\d+\\.\\d+).*");
    private static final String PROPERTY_KEY = "confluence.user.whats.new.dont.show.version";
    private static final String VERSION_UNSET = "UNSET";
    private final UserAccessor userAccessor;
    private final ApplicationProperties applicationProperties;
    private final LoginManager loginManager;

    @Autowired
    public WhatsNewManager(@ComponentImport UserAccessor userAccessor, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport LoginManager loginManager) {
        this.userAccessor = userAccessor;
        this.applicationProperties = applicationProperties;
        this.loginManager = loginManager;
    }

    public boolean isShownForUser(ConfluenceUser user, boolean fromCheck) {
        String currentVersion;
        if (user == null) {
            return false;
        }
        if (this.hasNeverLoggedInBefore(user)) {
            try {
                this.setShownForUser(user, false);
            }
            catch (UserPreferences.PreferenceException e) {
                log.warn("Couldn't save the preference for the What's New dialog for user {}", (Object)user.getName(), (Object)e);
            }
            return false;
        }
        UserPreferences pref = this.getUserPreferences(user);
        if (pref == null) {
            return false;
        }
        String seenVersion = pref.getString(PROPERTY_KEY).orElse(null);
        boolean shown = this.isShownForVersions(seenVersion, currentVersion = this.getCurrentVersion());
        if (shown && fromCheck) {
            log.debug("Shown for user '{}' : don't-show version is {} but current version is {}", new Object[]{user.getName(), seenVersion, currentVersion});
        }
        return shown;
    }

    public void setShownForUser(ConfluenceUser user, boolean shown) throws UserPreferences.PreferenceException {
        UserPreferences pref = this.getUserPreferences(user);
        if (pref == null) {
            return;
        }
        String dontShowVersion = shown ? VERSION_UNSET : this.getCurrentVersion();
        pref.setString(PROPERTY_KEY, dontShowVersion);
        log.debug("Preference changed for user '{}' : don't-show version is {}", new Object[]{user.getName(), dontShowVersion});
    }

    private boolean hasNeverLoggedInBefore(ConfluenceUser user) {
        LoginInfo loginInfo = this.loginManager.getLoginInfo((User)user);
        return loginInfo == null || loginInfo.getPreviousSuccessfulLoginDate() == null;
    }

    private boolean isShownForVersions(String seenVersion, String currentVersion) {
        if (seenVersion == null || VERSION_UNSET.equals(seenVersion)) {
            return true;
        }
        return !Objects.equal((Object)this.extractMajorVersion(currentVersion), (Object)this.extractMajorVersion(seenVersion));
    }

    @Nullable
    private String extractMajorVersion(String version) {
        Matcher matcher = MAJOR_VERSION_PATTERN.matcher(version);
        matcher.matches();
        return matcher.group(1);
    }

    private String getCurrentVersion() {
        return this.applicationProperties.getVersion();
    }

    private UserPreferences getUserPreferences(ConfluenceUser user) {
        if (user == null) {
            return null;
        }
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(user);
        if (userPreferences == null) {
            log.warn("Unable to set shownForUser preference for user: {}", (Object)user);
        }
        return userPreferences;
    }
}

