/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.whatsnew.context;

import com.atlassian.confluence.plugins.whatsnew.service.BuildInformationService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.web.UrlBuilder;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class WhatsNewContextProvider
implements ContextProvider {
    private String WHATS_NEW_BTF_URL = "https://confluence.atlassian.com/display/DOC/Confluence+%1s+Release+Notes";
    private final PermissionManager permissionManager;
    private final String baseFullLinkUrl;

    public WhatsNewContextProvider(@ComponentImport PermissionManager permissionManager, BuildInformationService buildInformationService) {
        this.WHATS_NEW_BTF_URL = String.format(this.WHATS_NEW_BTF_URL, buildInformationService.getMajorVersion());
        this.permissionManager = permissionManager;
        this.baseFullLinkUrl = new UrlBuilder(this.WHATS_NEW_BTF_URL).toUrl();
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> stringObjectMap) {
        return ImmutableMap.of((Object)"whatsnewFullLink", (Object)this.getFullLinkUrl(AuthenticatedUserThreadLocal.get()));
    }

    private String getFullLinkUrl(ConfluenceUser user) {
        UrlBuilder fullLinkBuilder = new UrlBuilder(this.baseFullLinkUrl);
        if (user != null && !Strings.isNullOrEmpty((String)user.getEmail())) {
            fullLinkBuilder.add("a", this.permissionManager.isConfluenceAdministrator(user));
        }
        return fullLinkBuilder.toUrl();
    }
}

