/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.license.rest.resource;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.LicenseWebFacade;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.confluence.license.rest.model.LicenseDetailsModel;
import com.atlassian.confluence.license.rest.model.UserCountResourceModel;
import com.atlassian.confluence.license.util.ConfluenceLicenseUtils;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.confluence.util.db.DatabaseUtils;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.DataCenterCrossgradeablePlugins;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.atlassian.fugue.Either;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/license")
@ReadOnlyAccessAllowed
@AdminOnly
public class LicenseResource {
    private static final Logger log = LoggerFactory.getLogger(LicenseResource.class);
    private final LicenseWebFacade licenseWebFacade;
    private final BootstrapManager bootstrapManager;
    private final ClusterManager clusterManager;
    private final I18nResolver i18nResolver;
    private final LicenseService licenseService;
    private final UserChecker userChecker;
    private final DataCenterCrossgradeablePlugins dataCenterCrossgradeablePlugins;

    @Inject
    public LicenseResource(@ComponentImport @Qualifier(value="licenseWebFacade") LicenseWebFacade licenseWebFacade, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport ClusterManager clusterManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport LicenseService licenseService, @ComponentImport UserChecker userChecker, @ComponentImport DataCenterCrossgradeablePlugins dataCenterCrossgradeablePlugins) {
        this.bootstrapManager = bootstrapManager;
        this.licenseWebFacade = licenseWebFacade;
        this.clusterManager = clusterManager;
        this.i18nResolver = i18nResolver;
        this.licenseService = licenseService;
        this.userChecker = userChecker;
        this.dataCenterCrossgradeablePlugins = dataCenterCrossgradeablePlugins;
    }

    @GET
    @Path(value="/details")
    public Response getDetails() {
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            LicenseDetailsModel licenseDetails = LicenseDetailsModel.builder().licenseType(license.getLicenseType().name()).dataCenter(license.isClusteringEnabled()).subscription(license.isSubscription()).evaluation(license.isEvaluation()).expired(license.isExpired()).creationDate(license.getCreationDate()).purchaseDate(license.getPurchaseDate()).expiryDate(license.getExpiryDate()).maintenanceExpiryDate(license.getMaintenanceExpiryDate()).build();
            return Response.ok((Object)licenseDetails).build();
        }
        catch (LicenseException e) {
            log.error("License not found or cannot be decrypted.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/organisation")
    public Response getOrganisation() {
        try {
            String org = this.licenseService.retrieve().getOrganisation().getName();
            return Response.ok((Object)org).build();
        }
        catch (LicenseException e) {
            log.error("License not found or cannot be decrypted.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/userCount")
    public Response getUserCount() {
        Integer userCount = this.userChecker.getNumberOfRegisteredUsers();
        log.info("There are {} users on this instance.", (Object)userCount);
        return Response.ok((Object)new UserCountResourceModel(userCount)).build();
    }

    @GET
    @Path(value="/remainingSeats")
    public Response getRemainingUserCount() {
        int userCount = this.userChecker.getNumberOfRegisteredUsers();
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            Integer remainingFreeSlots = license.isUnlimitedNumberOfUsers() ? Integer.MAX_VALUE : license.getMaximumNumberOfUsers() - userCount;
            log.info("There are {} remaining free slots on this instance.", (Object)remainingFreeSlots);
            return Response.ok((Object)new UserCountResourceModel(remainingFreeSlots)).build();
        }
        catch (LicenseException e) {
            log.error("License not found or cannot be decrypted.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/maxUsers")
    public Response getMaxUsers() {
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            Integer maxUsers = license.isUnlimitedNumberOfUsers() ? Integer.MAX_VALUE : license.getMaximumNumberOfUsers();
            log.info("This license allows for {} users", (Object)maxUsers);
            return Response.ok((Object)new UserCountResourceModel(maxUsers)).build();
        }
        catch (LicenseException e) {
            log.error("License not found or cannot be decrypted.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @POST
    @Path(value="/validate")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response validate(@FormParam(value="licenseKey") String licenseKey) {
        return (Response)this.licenseWebFacade.validateLicense(licenseKey).flatMap(this::validateDcEvaluationDb).fold(errorMessage -> Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errorMessage).build(), license -> Response.ok((Object)new ValidationResponse(this, (ConfluenceLicense)license)).build());
    }

    private Either<String, ConfluenceLicense> validateDcEvaluationDb(ConfluenceLicense license) {
        if (ConfluenceLicenseUtils.isDataCenter((ConfluenceLicense)license) && DatabaseUtils.evaluationDatabaseName((BootstrapManager)this.bootstrapManager).isPresent()) {
            return Either.left((Object)this.i18nResolver.getText("setup.start.cluster.upgrade.cannot.start.embedded.db", new Serializable[]{(Serializable)DatabaseUtils.evaluationDatabaseName().get()}));
        }
        return Either.right((Object)license);
    }

    class ValidationResponse {
        private final List<String> crossgradeableApps = new ArrayList<String>();
        private final boolean evaluation;
        private final boolean clusteringEnabled;

        ValidationResponse(LicenseResource this$0, ConfluenceLicense license) {
            this.evaluation = license.isEvaluation();
            this.clusteringEnabled = license.isClusteringEnabled();
            if (this.clusteringEnabled && !this$0.licenseService.isLicensedForDataCenter()) {
                this$0.dataCenterCrossgradeablePlugins.getDataCenterLicenseCrossgradeablePlugins().forEach(a -> this.crossgradeableApps.add(a.getName()));
            }
        }

        @JsonProperty
        public List<String> getCrossgradeableApps() {
            return this.crossgradeableApps;
        }

        @JsonProperty
        public Boolean isEvaluation() {
            return this.evaluation;
        }

        @JsonProperty
        public boolean isClusteringEnabled() {
            return this.clusteringEnabled;
        }
    }
}

