/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Collection;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.impl.DefaultTypeResolverBuilder;
import tools.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import tools.jackson.dataformat.xml.XmlTypeResolverBuilder;
import tools.jackson.dataformat.xml.util.StaxUtil;

public class DefaultingXmlTypeResolverBuilder
extends DefaultTypeResolverBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;

    public DefaultingXmlTypeResolverBuilder(PolymorphicTypeValidator ptv, DefaultTyping applicability, JsonTypeInfo.As includeAs) {
        super(ptv, applicability, includeAs);
    }

    public DefaultingXmlTypeResolverBuilder(PolymorphicTypeValidator ptv, DefaultTyping applicability, String propertyName) {
        super(ptv, applicability, propertyName);
    }

    public StdTypeResolverBuilder init(JsonTypeInfo.Value settings, TypeIdResolver idRes) {
        super.init(settings, idRes);
        if (this._typeProperty != null) {
            this._typeProperty = StaxUtil.sanitizeXmlTypeName(this._typeProperty);
        }
        return this;
    }

    protected TypeIdResolver idResolver(DatabindContext ctxt, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        switch (this._idType) {
            case CLASS: {
                return new XmlTypeResolverBuilder.XmlClassNameIdResolver(baseType, subtypes, this.subTypeValidator(ctxt));
            }
            case MINIMAL_CLASS: {
                return new XmlTypeResolverBuilder.XmlMinimalClassNameIdResolver(baseType, subtypes, this.subTypeValidator(ctxt));
            }
        }
        return super.idResolver(ctxt, baseType, subtypeValidator, subtypes, forSer, forDeser);
    }
}

