/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.io.Stax2ByteArraySource;
import org.codehaus.stax2.io.Stax2CharArraySource;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.base.TextualTSFactory;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.exc.StreamWriteException;
import tools.jackson.core.io.IOContext;
import tools.jackson.dataformat.xml.PackageVersion;
import tools.jackson.dataformat.xml.XmlFactoryBuilder;
import tools.jackson.dataformat.xml.XmlNameProcessor;
import tools.jackson.dataformat.xml.XmlNameProcessors;
import tools.jackson.dataformat.xml.XmlPrettyPrinter;
import tools.jackson.dataformat.xml.XmlReadFeature;
import tools.jackson.dataformat.xml.XmlWriteFeature;
import tools.jackson.dataformat.xml.deser.FromXmlParser;
import tools.jackson.dataformat.xml.ser.ToXmlGenerator;
import tools.jackson.dataformat.xml.util.StaxUtil;

public class XmlFactory
extends TextualTSFactory
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String FORMAT_NAME_XML = "XML";
    protected static final int DEFAULT_XML_READ_FEATURE_FLAGS = XmlReadFeature.collectDefaults();
    protected static final int DEFAULT_XML_WRITE_FEATURE_FLAGS = XmlWriteFeature.collectDefaults();
    protected final String _cfgNameForTextElement;
    protected final XmlNameProcessor _nameProcessor;
    protected final transient XMLInputFactory _xmlInputFactory;
    protected final transient XMLOutputFactory _xmlOutputFactory;
    protected transient String _jdkXmlInFactory;
    protected transient String _jdkXmlOutFactory;

    public XmlFactory() {
        this(null, (XMLOutputFactory)null);
    }

    public XmlFactory(XMLInputFactory xmlIn) {
        this(xmlIn, null);
    }

    public XmlFactory(XMLInputFactory xmlIn, XMLOutputFactory xmlOut) {
        this(DEFAULT_XML_READ_FEATURE_FLAGS, DEFAULT_XML_WRITE_FEATURE_FLAGS, xmlIn, xmlOut, XmlNameProcessors.newPassthroughProcessor(), "");
    }

    protected XmlFactory(int xpFeatures, int xgFeatures, XMLInputFactory xmlIn, XMLOutputFactory xmlOut, XmlNameProcessor nameProcessor, String nameForTextElem) {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), xpFeatures, xgFeatures);
        this._nameProcessor = nameProcessor;
        this._cfgNameForTextElement = nameForTextElem;
        if (xmlIn == null) {
            xmlIn = XmlFactoryBuilder.defaultXmlInputFactory(this.getClass().getClassLoader());
        }
        if (xmlOut == null) {
            xmlOut = XmlFactoryBuilder.defaultXmlOutputFactory(this.getClass().getClassLoader());
        }
        this._initFactories(xmlIn, xmlOut);
        this._xmlInputFactory = xmlIn;
        this._xmlOutputFactory = xmlOut;
    }

    protected XmlFactory(XmlFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
        this._cfgNameForTextElement = b.nameForTextElement();
        this._xmlInputFactory = b.xmlInputFactory();
        this._xmlOutputFactory = b.xmlOutputFactory();
        this._nameProcessor = b.xmlNameProcessor();
        this._initFactories(this._xmlInputFactory, this._xmlOutputFactory);
    }

    protected XmlFactory(XmlFactory src) {
        this(src, src._cfgNameForTextElement);
    }

    protected XmlFactory(XmlFactory src, String nameForTextElement) {
        super((TextualTSFactory)src);
        this._cfgNameForTextElement = nameForTextElement;
        this._xmlInputFactory = src._xmlInputFactory;
        this._xmlOutputFactory = src._xmlOutputFactory;
        this._nameProcessor = src._nameProcessor;
    }

    protected void _initFactories(XMLInputFactory xmlIn, XMLOutputFactory xmlOut) {
        xmlOut.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        xmlIn.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
    }

    public XmlFactoryBuilder rebuild() {
        return new XmlFactoryBuilder(this);
    }

    public static XmlFactoryBuilder builder() {
        return new XmlFactoryBuilder();
    }

    public static XmlFactoryBuilder builderWithJackson2Defaults() {
        return (XmlFactoryBuilder)XmlFactory.builder().configureForJackson2();
    }

    public XmlFactory copy() {
        return new XmlFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    public XmlFactory withNameForTextElement(String name) {
        if (name == null) {
            name = "";
        }
        if (name.equals(this._cfgNameForTextElement)) {
            return this;
        }
        return new XmlFactory(this, name);
    }

    protected Object readResolve() {
        XMLOutputFactory outf;
        XMLInputFactory inf;
        if (this._jdkXmlInFactory == null) {
            throw new IllegalStateException("No XMLInputFactory class name read during JDK deserialization");
        }
        if (this._jdkXmlOutFactory == null) {
            throw new IllegalStateException("No XMLOutputFactory class name read during JDK deserialization");
        }
        try {
            inf = (XMLInputFactory)Class.forName(this._jdkXmlInFactory).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            outf = (XMLOutputFactory)Class.forName(this._jdkXmlOutFactory).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return new XmlFactory(this._formatReadFeatures, this._formatWriteFeatures, inf, outf, this._nameProcessor, this._cfgNameForTextElement);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._jdkXmlInFactory = in.readUTF();
        this._jdkXmlOutFactory = in.readUTF();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this._xmlInputFactory.getClass().getName());
        out.writeUTF(this._xmlOutputFactory.getClass().getName());
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean canParseAsync() {
        return false;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME_XML;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public Class<XmlReadFeature> getFormatReadFeatureType() {
        return XmlReadFeature.class;
    }

    public Class<XmlWriteFeature> getFormatWriteFeatureType() {
        return XmlWriteFeature.class;
    }

    public int getFormatReadFeatures() {
        return this._formatReadFeatures;
    }

    public int getFormatWriteFeatures() {
        return this._formatWriteFeatures;
    }

    public String getXMLTextElementName() {
        return this._cfgNameForTextElement;
    }

    public XMLInputFactory getXMLInputFactory() {
        return this._xmlInputFactory;
    }

    public XMLOutputFactory getXMLOutputFactory() {
        return this._xmlOutputFactory;
    }

    public JsonParser createParser(ObjectReadContext readCtxt, String content) {
        IOContext ioCtxt = this._createContext(this._createContentReference(content), true);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, new StringReader(content)));
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ctxt, DataInput input) {
        return (JsonParser)this._unsupported();
    }

    protected JsonGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, Writer out) {
        return this._toXmlGenerator(writeCtxt, ioCtxt, this._createXmlWriter(out));
    }

    protected JsonGenerator _createUTF8Generator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) {
        return this._toXmlGenerator(writeCtxt, ioCtxt, this._createXmlWriter(out));
    }

    private final XmlPrettyPrinter _xmlPrettyPrinter(ObjectWriteContext writeCtxt) {
        PrettyPrinter pp = writeCtxt.getPrettyPrinter();
        if (pp == null) {
            return null;
        }
        if (!(pp instanceof XmlPrettyPrinter)) {
            throw new IllegalStateException("Configured PrettyPrinter not of type `XmlPrettyPrinter` but `" + pp.getClass().getName() + "`");
        }
        return (XmlPrettyPrinter)pp;
    }

    protected ToXmlGenerator _toXmlGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, XMLStreamWriter sw) {
        return new ToXmlGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), sw, this._xmlPrettyPrinter(writeCtxt), this._nameProcessor);
    }

    public FromXmlParser createParser(ObjectReadContext readCtxt, XMLStreamReader sr) throws IOException {
        if (sr.getEventType() != 1) {
            sr = this._initializeXmlReader(sr);
        }
        return this._fromXmlParser(readCtxt, this._createContext(this._createContentReference(sr), false), sr);
    }

    public ToXmlGenerator createGenerator(ObjectWriteContext writeCtxt, XMLStreamWriter sw) throws IOException {
        sw = this._initializeXmlWriter(sw);
        IOContext ioCtxt = this._createContext(this._createContentReference(sw), false);
        return this._toXmlGenerator(writeCtxt, ioCtxt, sw);
    }

    protected FromXmlParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory.createXMLStreamReader(in);
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)StaxUtil.throwAsReadException(e, null);
        }
        return this._fromXmlParser(readCtxt, ioCtxt, this._initializeXmlReader(sr));
    }

    protected FromXmlParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, Reader r) {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory.createXMLStreamReader(r);
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)StaxUtil.throwAsReadException(e, null);
        }
        return this._fromXmlParser(readCtxt, ioCtxt, this._initializeXmlReader(sr));
    }

    protected FromXmlParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, char[] data, int offset, int len, boolean recycleBuffer) {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory instanceof XMLInputFactory2 ? this._xmlInputFactory.createXMLStreamReader((Source)new Stax2CharArraySource(data, offset, len)) : this._xmlInputFactory.createXMLStreamReader(new CharArrayReader(data, offset, len));
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)StaxUtil.throwAsReadException(e, null);
        }
        return this._fromXmlParser(readCtxt, ioCtxt, this._initializeXmlReader(sr));
    }

    protected FromXmlParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory instanceof XMLInputFactory2 ? this._xmlInputFactory.createXMLStreamReader((Source)new Stax2ByteArraySource(data, offset, len)) : this._xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(data, offset, len));
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)StaxUtil.throwAsReadException(e, null);
        }
        return this._fromXmlParser(readCtxt, ioCtxt, this._initializeXmlReader(sr));
    }

    protected FromXmlParser _fromXmlParser(ObjectReadContext readCtxt, IOContext ioCtxt, XMLStreamReader sr) {
        return new FromXmlParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), sr, this._nameProcessor, this._cfgNameForTextElement);
    }

    protected XMLStreamWriter _createXmlWriter(OutputStream out) {
        XMLStreamWriter sw;
        try {
            sw = this._xmlOutputFactory.createXMLStreamWriter(out, "UTF-8");
        }
        catch (XMLStreamException e) {
            return (XMLStreamWriter)StaxUtil.throwAsWriteException(e, null);
        }
        return this._initializeXmlWriter(sw);
    }

    protected XMLStreamWriter _createXmlWriter(Writer w) {
        XMLStreamWriter sw;
        try {
            sw = this._xmlOutputFactory.createXMLStreamWriter(w);
        }
        catch (XMLStreamException e) {
            return (XMLStreamWriter)StaxUtil.throwAsWriteException(e, null);
        }
        return this._initializeXmlWriter(sw);
    }

    protected final XMLStreamWriter _initializeXmlWriter(XMLStreamWriter sw) {
        try {
            sw.setDefaultNamespace("");
        }
        catch (Exception e) {
            throw new StreamWriteException(null, e.getMessage(), (Throwable)e);
        }
        return sw;
    }

    protected final XMLStreamReader _initializeXmlReader(XMLStreamReader sr) {
        try {
            while (sr.next() != 1) {
            }
        }
        catch (Exception e) {
            throw new StreamReadException(null, e.getMessage(), (Throwable)e);
        }
        return sr;
    }
}

