/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.deser;

import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.InjectableValues;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.DeserializationContextExt;
import tools.jackson.databind.deser.DeserializerCache;
import tools.jackson.databind.deser.DeserializerFactory;
import tools.jackson.dataformat.xml.XmlFactory;

public class XmlDeserializationContext
extends DeserializationContextExt {
    private final String _xmlTextElementName;

    public XmlDeserializationContext(TokenStreamFactory tsf, DeserializerFactory deserializerFactory, DeserializerCache cache, DeserializationConfig config, FormatSchema schema, InjectableValues values) {
        super(tsf, deserializerFactory, cache, config, schema, values);
        this._xmlTextElementName = ((XmlFactory)tsf).getXMLTextElementName();
    }

    public Object readRootValue(JsonParser p, JavaType valueType, ValueDeserializer<Object> deser, Object valueToUpdate) throws JacksonException {
        if (this._config.useRootWrapping()) {
            return this._unwrapAndDeserialize(p, valueType, deser, valueToUpdate);
        }
        if (valueToUpdate == null) {
            return deser.deserialize(p, (DeserializationContext)this);
        }
        return deser.deserialize(p, (DeserializationContext)this, valueToUpdate);
    }

    public String extractScalarFromObject(JsonParser p, ValueDeserializer<?> deser, Class<?> scalarType) throws JacksonException {
        String text = "";
        while (p.nextToken() == JsonToken.PROPERTY_NAME) {
            String propName = p.currentName();
            JsonToken t = p.nextToken();
            if (t == JsonToken.VALUE_STRING) {
                if (!propName.equals(this._xmlTextElementName)) continue;
                text = p.getString();
                continue;
            }
            p.skipChildren();
        }
        return text;
    }
}

