/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.deser;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.bean.BeanDeserializerBase;
import tools.jackson.databind.deser.std.DelegatingDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;

public class XmlTextDeserializer
extends DelegatingDeserializer {
    protected final int _xmlTextPropertyIndex;
    protected final SettableBeanProperty _xmlTextProperty;
    protected final ValueInstantiator _valueInstantiator;

    public XmlTextDeserializer(BeanDeserializerBase delegate, SettableBeanProperty prop) {
        super((ValueDeserializer)delegate);
        this._xmlTextProperty = prop;
        this._xmlTextPropertyIndex = prop.getPropertyIndex();
        this._valueInstantiator = delegate.getValueInstantiator();
    }

    public XmlTextDeserializer(BeanDeserializerBase delegate, int textPropIndex) {
        super((ValueDeserializer)delegate);
        this._xmlTextPropertyIndex = textPropIndex;
        this._valueInstantiator = delegate.getValueInstantiator();
        this._xmlTextProperty = delegate.findProperty(textPropIndex);
    }

    protected ValueDeserializer<?> newDelegatingInstance(ValueDeserializer<?> newDelegatee0) {
        throw new IllegalStateException("Internal error: should never get called");
    }

    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType vt = ctxt.constructType(this._delegatee.handledType());
        ValueDeserializer del = ctxt.handleSecondaryContextualization(this._delegatee, property, vt);
        return new XmlTextDeserializer(this._verifyDeserType(del), this._xmlTextPropertyIndex);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.currentToken() == JsonToken.VALUE_STRING) {
            Object bean = this._valueInstantiator.createUsingDefault(ctxt);
            this._xmlTextProperty.deserializeAndSet(p, ctxt, bean);
            return bean;
        }
        return this._delegatee.deserialize(p, ctxt);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        if (p.currentToken() == JsonToken.VALUE_STRING) {
            this._xmlTextProperty.deserializeAndSet(p, ctxt, bean);
            return bean;
        }
        return this._delegatee.deserialize(p, ctxt, bean);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        return this._delegatee.deserializeWithType(p, ctxt, typeDeserializer);
    }

    protected BeanDeserializerBase _verifyDeserType(ValueDeserializer<?> deser) {
        if (!(deser instanceof BeanDeserializerBase)) {
            throw new IllegalArgumentException("Can not change delegate to be of type " + deser.getClass().getName());
        }
        return (BeanDeserializerBase)deser;
    }
}

